/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.util.KeysTrackingConfigurationVisitor;
import org.jetbrains.annotations.Nullable;

public class ConfigurationFlattener {
    public static Map<String, Serializable> createFlattenedUpdatesMap(SuperRoot curRoot, SuperRoot updates, NavigableMap<String, ? extends Serializable> storageData) {
        HashMap<String, Serializable> resMap = new HashMap<String, Serializable>();
        ArrayDeque<InnerNode> oldInnerNodesStack = new ArrayDeque<InnerNode>();
        oldInnerNodesStack.push(curRoot);
        updates.traverseChildren(new FlattenerVisitor(oldInnerNodesStack, resMap, storageData), true);
        assert (oldInnerNodesStack.peek() == curRoot) : oldInnerNodesStack;
        return resMap;
    }

    private static Map<String, Integer> keysToOrderIdx(NamedListNode<?> node) {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        int idx = 0;
        for (String key : node.namedListKeys()) {
            if (node.getInnerNode(key) == null) continue;
            res.put(key, idx++);
        }
        return res;
    }

    private static class FlattenerVisitor
    extends KeysTrackingConfigurationVisitor<Object> {
        private final Deque<InnerNode> oldInnerNodesStack;
        private final Map<String, Serializable> resMap;
        private final NavigableMap<String, ? extends Serializable> storageData;
        private boolean singleTreeTraversal;
        private boolean deletion;

        FlattenerVisitor(Deque<InnerNode> oldInnerNodesStack, Map<String, Serializable> resMap, NavigableMap<String, ? extends Serializable> storageData) {
            this.oldInnerNodesStack = oldInnerNodesStack;
            this.resMap = resMap;
            this.storageData = storageData;
        }

        private void putToMap(boolean mustOverride, boolean delete, Supplier<String> key, @Nullable Serializable newVal) {
            if (mustOverride) {
                this.resMap.put(key.get(), delete ? null : newVal);
            } else {
                String currentKey = key.get();
                if (!this.storageData.containsKey(currentKey)) {
                    this.resMap.put(currentKey, newVal);
                }
            }
        }

        @Override
        public Void doVisitLeafNode(Field field, String key, Serializable newVal) {
            Serializable oldVal = this.oldInnerNodesStack.element().traverseChild(key, ConfigurationUtil.leafNodeVisitor(), true);
            this.putToMap(this.singleTreeTraversal || !Objects.deepEquals(oldVal, newVal), this.deletion, this::currentKey, newVal);
            return null;
        }

        @Override
        protected Object doVisitLegacyLeafNode(Field field, String key, Serializable val, boolean isDeprecated) {
            String currentKey = this.currentKey();
            if (this.storageData.containsKey(currentKey)) {
                this.resMap.put(currentKey, null);
            }
            return null;
        }

        @Override
        public Void doVisitInnerNode(Field field, String key, InnerNode newNode) {
            InnerNode oldNode = this.oldInnerNodesStack.element().traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
            if (oldNode == null && newNode == null) {
                return null;
            }
            if (oldNode == null) {
                this.visitAsymmetricInnerNode(newNode, false);
            } else if (oldNode.schemaType() != newNode.schemaType()) {
                this.visitAsymmetricInnerNode(oldNode, true);
                this.visitAsymmetricInnerNode(newNode, false);
            } else {
                this.oldInnerNodesStack.push(oldNode);
                newNode.traverseChildren(this, true);
                this.oldInnerNodesStack.pop();
            }
            return null;
        }

        @Override
        protected Object doVisitLegacyInnerNode(Field field, String key, InnerNode node, boolean isDeprecated) {
            this.dropOutdatedData();
            return null;
        }

        @Override
        public Void doVisitNamedListNode(Field field, String key, NamedListNode<?> newNode) {
            NamedListNode<?> oldNode = this.oldInnerNodesStack.element().traverseChild(key, ConfigurationUtil.namedListNodeVisitor(), true);
            Map<String, Integer> oldKeysToOrderIdxMap = this.singleTreeTraversal ? null : ConfigurationFlattener.keysToOrderIdx(oldNode);
            Map<String, Integer> newKeysToOrderIdxMap = this.deletion ? null : ConfigurationFlattener.keysToOrderIdx(newNode);
            for (String newNodeKey : newNode.namedListKeys()) {
                UUID newNodeInternalId = newNode.internalId(newNodeKey);
                String namedListFullKey = this.currentKey();
                this.withTracking(field, newNodeInternalId.toString(), false, false, () -> {
                    InnerNode newNamedElement = newNode.getInnerNode(newNodeKey);
                    String oldNodeKey = oldNode.keyByInternalId(newNodeInternalId);
                    InnerNode oldNamedElement = oldNode.getInnerNode(oldNodeKey);
                    if (oldNamedElement == null && newNamedElement == null) {
                        return null;
                    }
                    if (newNamedElement == null) {
                        this.visitAsymmetricInnerNode(oldNamedElement, true);
                    } else if (oldNamedElement == null) {
                        this.visitAsymmetricInnerNode(newNamedElement, false);
                    } else if (newNamedElement.schemaType() != oldNamedElement.schemaType()) {
                        this.visitAsymmetricInnerNode(oldNamedElement, true);
                        this.visitAsymmetricInnerNode(newNamedElement, false);
                    } else {
                        this.oldInnerNodesStack.push(oldNamedElement);
                        newNamedElement.traverseChildren(this, true);
                        this.oldInnerNodesStack.pop();
                    }
                    Integer newIdx = newKeysToOrderIdxMap == null ? null : (Integer)newKeysToOrderIdxMap.get(newNodeKey);
                    Integer oldIdx = oldKeysToOrderIdxMap == null ? null : (Integer)oldKeysToOrderIdxMap.get(newNodeKey);
                    this.putToMap(!Objects.equals(newIdx, oldIdx) || this.singleTreeTraversal || newNamedElement == null, this.deletion || newNamedElement == null, () -> this.currentKey() + "<order>", newIdx);
                    this.putToMap(this.singleTreeTraversal || oldNamedElement == null || newNamedElement == null || !oldNodeKey.equals(newNodeKey), this.deletion || newNamedElement == null, () -> this.currentKey() + "<name>", (Serializable)((Object)newNodeKey));
                    if (this.singleTreeTraversal) {
                        if (this.deletion) {
                            this.resMap.put(FlattenerVisitor.idKey(namedListFullKey, oldNodeKey), null);
                        } else {
                            this.resMap.put(FlattenerVisitor.idKey(namedListFullKey, newNodeKey), newNodeInternalId);
                        }
                    } else if (newNamedElement == null) {
                        this.resMap.put(FlattenerVisitor.idKey(namedListFullKey, oldNodeKey), null);
                    } else if (oldNamedElement == null) {
                        this.resMap.put(FlattenerVisitor.idKey(namedListFullKey, newNodeKey), newNodeInternalId);
                    } else if (!oldNodeKey.equals(newNodeKey)) {
                        this.resMap.put(FlattenerVisitor.idKey(namedListFullKey, oldNodeKey), null);
                        this.resMap.put(FlattenerVisitor.idKey(namedListFullKey, newNodeKey), newNodeInternalId);
                    }
                    String idKey = FlattenerVisitor.idKey(namedListFullKey, newNodeKey);
                    if (!this.storageData.containsKey(idKey)) {
                        this.resMap.put(idKey, newNodeInternalId);
                    }
                    return null;
                });
            }
            return null;
        }

        @Override
        protected Object doVisitLegacyNamedListNode(Field field, String key, NamedListNode<?> node, boolean isDeprecated) {
            this.dropOutdatedData();
            return null;
        }

        private void dropOutdatedData() {
            String currentKey = this.currentKey();
            SortedMap<String, ? extends Serializable> tailMap = this.storageData.tailMap(currentKey);
            for (String storageKey : tailMap.keySet()) {
                if (!storageKey.startsWith(currentKey)) break;
                this.resMap.put(storageKey, null);
            }
        }

        private static String idKey(String prefix, String nodeKey) {
            return prefix + "<ids>." + ConfigurationUtil.escape(nodeKey);
        }

        private void visitAsymmetricInnerNode(InnerNode node, boolean delete) {
            assert (node != null);
            this.oldInnerNodesStack.push(node);
            this.singleTreeTraversal = true;
            this.deletion = delete;
            node.traverseChildren(this, true);
            this.deletion = false;
            this.singleTreeTraversal = false;
            this.oldInnerNodesStack.pop();
        }
    }
}

