/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWindow;

public enum RexWindowExclusion {
    EXCLUDE_NO_OTHER("EXCLUDE NO OTHER"),
    EXCLUDE_CURRENT_ROW("EXCLUDE CURRENT ROW"),
    EXCLUDE_TIES("EXCLUDE TIES"),
    EXCLUDE_GROUP("EXCLUDE GROUP");

    private final String sql;

    private RexWindowExclusion(String sql) {
        this.sql = sql;
    }

    public String toString() {
        return this.sql;
    }

    public static RexWindowExclusion create(SqlNode node) {
        SqlLiteral exclude = (SqlLiteral)node;
        if (SqlWindow.isExcludeCurrentRow(exclude)) {
            return EXCLUDE_CURRENT_ROW;
        }
        if (SqlWindow.isExcludeNoOthers(exclude)) {
            return EXCLUDE_NO_OTHER;
        }
        if (SqlWindow.isExcludeGroup(exclude)) {
            return EXCLUDE_GROUP;
        }
        if (SqlWindow.isExcludeTies(exclude)) {
            return EXCLUDE_TIES;
        }
        throw new AssertionError((Object)"Unexpected Exclusion clause");
    }
}

