/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.time.ZoneId;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.sql.engine.SqlOperationContext;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhaseHandler;
import org.apache.ignite.internal.sql.engine.exec.fsm.Query;
import org.apache.ignite.internal.sql.engine.exec.fsm.Result;
import org.apache.ignite.internal.sql.engine.exec.fsm.ValidationHelper;
import org.apache.ignite.internal.sql.engine.prepare.QueryPlan;
import org.apache.ignite.internal.sql.engine.sql.ParsedResult;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionContext;
import org.apache.ignite.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;

class OptimizingPhaseHandler
implements ExecutionPhaseHandler {
    static final ExecutionPhaseHandler INSTANCE = new OptimizingPhaseHandler();

    private OptimizingPhaseHandler() {
    }

    @Override
    public Result handle(Query query) {
        SqlOperationContext operationContext;
        ParsedResult result = query.parsedResult;
        assert (result != null) : "Query is expected to be parsed at this phase";
        ValidationHelper.validateParsedStatement(query.properties, result);
        ValidationHelper.validateDynamicParameters(result.dynamicParamsCount(), query.params, true);
        OptimizingPhaseHandler.ensureStatementMatchesTx(result.queryType(), query.txContext);
        HybridTimestamp operationTime = query.executor.deriveOperationTime(query.txContext);
        String schemaName = query.properties.defaultSchema();
        ZoneId timeZoneId = query.properties.timeZoneId();
        String userName = query.properties.userName();
        query.operationContext = operationContext = SqlOperationContext.builder().queryId(query.id).cancel(query.cancel).parameters(query.params).timeZoneId(timeZoneId).defaultSchemaName(schemaName).operationTime(operationTime).txContext(query.txContext).txUsedListener(tx -> {
            query.usedTransaction = tx;
        }).errorHandler(query::setError).userName(userName).build();
        CompletionStage awaitFuture = query.executor.waitForMetadata(operationTime).thenCompose(none -> query.executor.prepare(result, operationContext).thenAccept(plan -> {
            if (query.txContext.explicitTx() == null) {
                query.txContext.updateObservableTime(query.executor.deriveMinimalRequiredTime((QueryPlan)plan));
            }
            query.plan = plan;
        }));
        return Result.proceedAfter((CompletableFuture<Void>)awaitFuture);
    }

    private static void ensureStatementMatchesTx(SqlQueryType queryType, QueryTransactionContext txContext) {
        QueryTransactionWrapper txWrapper = txContext.explicitTx();
        if (txWrapper == null) {
            return;
        }
        if (!queryType.supportsExplicitTransactions()) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, queryType.displayName() + " doesn't support transactions.");
        }
        if (SqlQueryType.DML == queryType && txWrapper.unwrap().isReadOnly()) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, queryType.displayName() + " cannot be started by using read only transactions.");
        }
    }
}

