/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.util;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.GridUnsafe;

public class PageUtils {
    public static byte getByte(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getByte((long)(addr + (long)off));
    }

    public static int getUnsignedByte(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getByte((long)(addr + (long)off)) & 0xFF;
    }

    public static byte[] getBytes(long addr, int off, int len) {
        return GridUnsafe.getBytes((long)addr, (int)off, (int)len);
    }

    public static void getBytes(long srcAddr, int srcOff, byte[] dst, int dstOff, int len) {
        assert (srcAddr > 0L);
        assert (srcOff > 0);
        assert (dst != null);
        assert (dstOff >= 0);
        assert (len >= 0);
        GridUnsafe.copyMemory(null, (long)(srcAddr + (long)srcOff), (Object)dst, (long)(GridUnsafe.BYTE_ARR_OFF + (long)dstOff), (long)len);
    }

    public static short getShort(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getShort((long)(addr + (long)off));
    }

    public static int getInt(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getInt((long)(addr + (long)off));
    }

    public static long getLong(long addr, int off) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        return GridUnsafe.getLong((long)(addr + (long)off));
    }

    public static void putBytes(long addr, int off, byte[] bytes) {
        PageUtils.putBytes(addr, off, bytes, 0, bytes.length);
    }

    public static void putBytes(long addr, int off, byte[] bytes, int bytesOff) {
        PageUtils.putBytes(addr, off, bytes, bytesOff, bytes.length - bytesOff);
    }

    public static void putBytes(long addr, int off, byte[] bytes, int bytesOff, int len) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        assert (bytes != null);
        assert (bytesOff >= 0 && (bytesOff < bytes.length || bytes.length == 0)) : bytesOff;
        assert (len >= 0 && bytesOff + len <= bytes.length);
        GridUnsafe.copyMemory((Object)bytes, (long)(GridUnsafe.BYTE_ARR_OFF + (long)bytesOff), null, (long)(addr + (long)off), (long)len);
    }

    public static void putByte(long addr, int off, byte v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        GridUnsafe.putByte((long)(addr + (long)off), (byte)v);
    }

    public static void putUnsignedByte(long addr, int off, int v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        assert (v >= 0 && v <= 255);
        GridUnsafe.putByte((long)(addr + (long)off), (byte)((byte)v));
    }

    public static void putShort(long addr, int off, short v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        GridUnsafe.putShort((long)(addr + (long)off), (short)v);
    }

    public static void putInt(long addr, int off, int v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        GridUnsafe.putInt((long)(addr + (long)off), (int)v);
    }

    public static void putLong(long addr, int off, long v) {
        assert (addr > 0L) : addr;
        assert (off >= 0);
        GridUnsafe.putLong((long)(addr + (long)off), (long)v);
    }

    public static void copyMemory(ByteBuffer src, long srcOff, ByteBuffer dst, long dstOff, long cnt) {
        byte[] srcArr = src.hasArray() ? src.array() : null;
        byte[] dstArr = dst.hasArray() ? dst.array() : null;
        long srcArrOff = src.hasArray() ? (long)src.arrayOffset() + GridUnsafe.BYTE_ARR_OFF : 0L;
        long dstArrOff = dst.hasArray() ? (long)dst.arrayOffset() + GridUnsafe.BYTE_ARR_OFF : 0L;
        long srcPtr = src.isDirect() ? GridUnsafe.bufferAddress((ByteBuffer)src) : 0L;
        long dstPtr = dst.isDirect() ? GridUnsafe.bufferAddress((ByteBuffer)dst) : 0L;
        GridUnsafe.copyMemory((Object)srcArr, (long)(srcPtr + srcArrOff + srcOff), (Object)dstArr, (long)(dstPtr + dstArrOff + dstOff), (long)cnt);
    }

    public static void copyMemory(long srcAddr, long srcOff, long dstAddr, long dstOff, long cnt) {
        GridUnsafe.copyMemory(null, (long)(srcAddr + srcOff), null, (long)(dstAddr + dstOff), (long)cnt);
    }

    public static void putByteBuffer(long addr, int off, ByteBuffer buf) {
        long srcOff;
        byte[] srcBase;
        assert (addr > 0L) : addr;
        assert (off >= 0) : off;
        assert (buf != null);
        if (buf.isDirect()) {
            srcBase = null;
            srcOff = GridUnsafe.bufferAddress((ByteBuffer)buf);
        } else {
            byte[] arr;
            assert (!buf.isReadOnly());
            srcBase = arr = buf.array();
            srcOff = GridUnsafe.BYTE_ARR_OFF + (long)buf.arrayOffset();
        }
        GridUnsafe.copyMemory((Object)srcBase, (long)(srcOff + (long)buf.position()), null, (long)(addr + (long)off), (long)(buf.limit() - buf.position()));
    }
}

