/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.reader;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.token.reader.TokenReader;
import io.micronaut.security.token.reader.TokenResolver;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultTokenResolver
implements TokenResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTokenResolver.class);
    private final Collection<TokenReader> tokenReaders;

    public DefaultTokenResolver(Collection<TokenReader> tokenReaders) {
        this.tokenReaders = tokenReaders;
    }

    @Override
    public Optional<String> resolveToken(HttpRequest<?> request) {
        Optional<String> token = this.tokenReaders.stream().map(reader -> reader.findToken(request)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
        if (LOG.isDebugEnabled()) {
            String method = request.getMethod().toString();
            String path = request.getPath();
            if (token.isPresent()) {
                LOG.debug("Token {} found in request {} {}", new Object[]{token.get(), method, path});
            } else {
                LOG.debug("Request {}, {}, no token found.", (Object)method, (Object)path);
            }
        }
        return token;
    }
}

