/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb;

import java.util.Arrays;
import java.util.Collection;
import org.apache.ignite.internal.rocksdb.RocksBiConsumer;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractNativeReference;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksUtils {
    public static void forEach(RocksIterator iterator, RocksBiConsumer consumer) throws RocksDBException {
        while (iterator.isValid()) {
            consumer.accept(iterator.key(), iterator.value());
            iterator.next();
        }
        iterator.status();
    }

    public static byte @Nullable [] incrementPrefix(byte[] prefix) {
        int i;
        for (i = prefix.length - 1; i >= 0 && prefix[i] == -1; --i) {
        }
        if (i == -1) {
            return null;
        }
        byte[] result = Arrays.copyOf(prefix, i + 1);
        int n = i;
        result[n] = (byte)(result[n] + 1);
        return result;
    }

    public static void closeAll(AbstractNativeReference ... references) {
        RocksUtils.closeAll(Arrays.asList(references));
    }

    public static void closeAll(Collection<? extends AbstractNativeReference> references) {
        RuntimeException exception = null;
        for (AbstractNativeReference abstractNativeReference : references) {
            if (abstractNativeReference == null) continue;
            try {
                abstractNativeReference.close();
            }
            catch (RuntimeException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

