/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.cluster;

import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.cluster.ClusterNode;

@Controller(value="/management/v1/cluster/topology")
@Tag(name="topology")
public interface TopologyApi {
    @Get(value="physical")
    @Operation(operationId="physical", summary="Get physical topology", description="Gets information about physical cluster topology.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Physical topology returned.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ClusterNode.class)))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public Collection<ClusterNode> physicalTopology();

    @Get(value="logical")
    @Operation(operationId="logical", summary="Get logical topology", description="Gets information about logical cluster topology.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Logical topology returned.", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ClusterNode.class)))}), @ApiResponse(responseCode="404", description="Logical topology not found. Most likely, the cluster is not initialized.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public CompletableFuture<Collection<ClusterNode>> logicalTopology();
}

