/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin.api;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;
import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.admin.model.CreatePrincipalRequest;
import org.apache.polaris.core.admin.model.GrantPrincipalRoleRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRequest;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.admin.api.PolarisPrincipalsApiService;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/management/v1/principals")
public class PolarisPrincipalsApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisPrincipalsApi.class);
    private final PolarisPrincipalsApiService service;

    @Inject
    public PolarisPrincipalsApi(PolarisPrincipalsApiService service) {
        this.service = service;
    }

    @PUT
    @Path(value="/{principalName}/principal-roles")
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principals.assignPrincipalRole")
    @Timeout
    public Response assignPrincipalRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalName, @Nonnull @Valid GrantPrincipalRoleRequest grantPrincipalRoleRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principals with params").addKeyValue("operation", (Object)"assignPrincipalRole").addKeyValue("principalName", (Object)principalName).addKeyValue("grantPrincipalRoleRequest", (Object)String.valueOf(grantPrincipalRoleRequest)).log();
        Response ret = this.service.assignPrincipalRole(principalName, grantPrincipalRoleRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of assignPrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principals.createPrincipal")
    @Timeout
    public Response createPrincipal(@Nonnull @Valid CreatePrincipalRequest createPrincipalRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principals with params").addKeyValue("operation", (Object)"createPrincipal").addKeyValue("createPrincipalRequest", (Object)String.valueOf(createPrincipalRequest)).log();
        Response ret = this.service.createPrincipal(createPrincipalRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of createPrincipal API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/{principalName}")
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principals.deletePrincipal")
    @Timeout
    public Response deletePrincipal(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principals with params").addKeyValue("operation", (Object)"deletePrincipal").addKeyValue("principalName", (Object)principalName).log();
        Response ret = this.service.deletePrincipal(principalName, realmContext, securityContext);
        LOGGER.debug("Completed execution of deletePrincipal API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{principalName}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principals.getPrincipal")
    @Timeout
    public Response getPrincipal(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principals with params").addKeyValue("operation", (Object)"getPrincipal").addKeyValue("principalName", (Object)principalName).log();
        Response ret = this.service.getPrincipal(principalName, realmContext, securityContext);
        LOGGER.debug("Completed execution of getPrincipal API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/{principalName}/principal-roles")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principals.listPrincipalRolesAssigned")
    @Timeout
    public Response listPrincipalRolesAssigned(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principals with params").addKeyValue("operation", (Object)"listPrincipalRolesAssigned").addKeyValue("principalName", (Object)principalName).log();
        Response ret = this.service.listPrincipalRolesAssigned(principalName, realmContext, securityContext);
        LOGGER.debug("Completed execution of listPrincipalRolesAssigned API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principals.listPrincipals")
    @Timeout
    public Response listPrincipals(@Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principals with params").addKeyValue("operation", (Object)"listPrincipals").log();
        Response ret = this.service.listPrincipals(realmContext, securityContext);
        LOGGER.debug("Completed execution of listPrincipals API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/{principalName}/principal-roles/{principalRoleName}")
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principals.revokePrincipalRole")
    @Timeout
    public Response revokePrincipalRole(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalName, @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalRoleName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalRoleName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principals with params").addKeyValue("operation", (Object)"revokePrincipalRole").addKeyValue("principalName", (Object)principalName).addKeyValue("principalRoleName", (Object)principalRoleName).log();
        Response ret = this.service.revokePrincipalRole(principalName, principalRoleName, realmContext, securityContext);
        LOGGER.debug("Completed execution of revokePrincipalRole API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/{principalName}/rotate")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principals.rotateCredentials")
    @Timeout
    public Response rotateCredentials(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalName, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principals with params").addKeyValue("operation", (Object)"rotateCredentials").addKeyValue("principalName", (Object)principalName).log();
        Response ret = this.service.rotateCredentials(principalName, realmContext, securityContext);
        LOGGER.debug("Completed execution of rotateCredentials API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @PUT
    @Path(value="/{principalName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.principals.updatePrincipal")
    @Timeout
    public Response updatePrincipal(@Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) @PathParam(value="principalName") @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String principalName, @Nonnull @Valid UpdatePrincipalRequest updatePrincipalRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking principals with params").addKeyValue("operation", (Object)"updatePrincipal").addKeyValue("principalName", (Object)principalName).addKeyValue("updatePrincipalRequest", (Object)String.valueOf(updatePrincipalRequest)).log();
        Response ret = this.service.updatePrincipal(principalName, updatePrincipalRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of updatePrincipal API with status code {}", (Object)ret.getStatus());
        return ret;
    }
}

