/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.archiving;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivingTask {
    private long taskId;
    private PartialPath storageGroup;
    private File targetDir;
    private long startTime;
    private long ttl;
    private volatile ArchivingTaskStatus status = ArchivingTaskStatus.READY;
    private long submitTime;
    private static final Logger logger = LoggerFactory.getLogger(ArchivingTask.class);
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    FileOutputStream logFileOutput = null;
    private static final File ARCHIVING_LOG_DIR = SystemFileFactory.INSTANCE.getFile(Paths.get(FilePathUtils.regularizePath((String)config.getSystemDir()), "archiving", "archiving_task").toString());

    public ArchivingTask(long taskId) {
        this.taskId = taskId;
    }

    public ArchivingTask(ArchivingTask task) {
        this.taskId = task.getTaskId();
        this.storageGroup = task.getStorageGroup();
        this.targetDir = task.getTargetDir();
        this.ttl = task.getTTL();
        this.startTime = task.getStartTime();
        this.submitTime = task.getSubmitTime();
    }

    public ArchivingTask(long taskId, PartialPath storageGroup, File targetDir, long ttl, long startTime) {
        this.taskId = taskId;
        this.storageGroup = storageGroup;
        this.targetDir = targetDir;
        this.ttl = ttl;
        this.startTime = startTime;
        this.submitTime = DateTimeUtils.currentTime();
    }

    public ArchivingTask(long taskId, PartialPath storageGroup, File targetDir, long ttl, long startTime, long submitTime) {
        this.taskId = taskId;
        this.storageGroup = storageGroup;
        this.targetDir = targetDir;
        this.ttl = ttl;
        this.startTime = startTime;
        this.submitTime = submitTime;
    }

    public boolean startTask() throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(ARCHIVING_LOG_DIR, this.taskId + ".log");
        if (logFile.exists()) {
            logFile.delete();
        }
        if (!logFile.createNewFile()) {
            return false;
        }
        this.logFileOutput = new FileOutputStream(logFile);
        ReadWriteIOUtils.write((String)this.targetDir.getAbsolutePath(), (OutputStream)this.logFileOutput);
        this.logFileOutput.flush();
        return true;
    }

    public boolean startFile(File tsfile) throws IOException {
        if (this.logFileOutput == null) {
            logger.error("need to run ArchivingTask.startTask before ArchivingTask.start");
            return false;
        }
        ReadWriteIOUtils.write((String)tsfile.getAbsolutePath(), (OutputStream)this.logFileOutput);
        this.logFileOutput.flush();
        return true;
    }

    public void finish() {
        File logFile = SystemFileFactory.INSTANCE.getFile(ARCHIVING_LOG_DIR, this.taskId + ".log");
        if (logFile.exists()) {
            logFile.delete();
        }
        this.close();
    }

    public void close() {
        try {
            if (this.logFileOutput != null) {
                this.logFileOutput.close();
                this.logFileOutput = null;
            }
        }
        catch (IOException e) {
            logger.error("could not close fileoutputstream for task {}", (Object)this.taskId);
        }
    }

    public long getTaskId() {
        return this.taskId;
    }

    public PartialPath getStorageGroup() {
        return this.storageGroup;
    }

    public File getTargetDir() {
        return this.targetDir;
    }

    public long getTTL() {
        return this.ttl;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public ArchivingTaskStatus getStatus() {
        return this.status;
    }

    public boolean isActive() {
        return this.status == ArchivingTaskStatus.READY || this.status == ArchivingTaskStatus.RUNNING || this.status == ArchivingTaskStatus.PAUSED;
    }

    public void setStatus(ArchivingTaskStatus status) {
        this.status = status;
    }

    public static enum ArchivingTaskStatus {
        READY,
        RUNNING,
        PAUSED,
        CANCELED,
        ERROR,
        FINISHED;

    }
}

