/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNode;
import org.eclipse.milo.opcua.sdk.core.nodes.MethodNodeProperties;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.sdk.server.api.methods.MethodInvocationHandler;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilter;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.Argument;
import org.jetbrains.annotations.Nullable;

public class UaMethodNode
extends UaNode
implements MethodNode {
    private volatile MethodInvocationHandler handler = MethodInvocationHandler.NOT_IMPLEMENTED;
    private volatile Boolean executable;
    private volatile Boolean userExecutable;

    public UaMethodNode(UaNodeContext context, NodeId nodeId, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, Boolean executable, Boolean userExecutable) {
        super(context, nodeId, NodeClass.Method, browseName, displayName, description, writeMask, userWriteMask);
        this.executable = executable;
        this.userExecutable = userExecutable;
    }

    public Boolean isExecutable() {
        return (Boolean)this.filterChain.getAttribute(this, AttributeId.Executable);
    }

    public Boolean isUserExecutable() {
        return (Boolean)this.filterChain.getAttribute(this, AttributeId.UserExecutable);
    }

    public void setExecutable(Boolean executable) {
        this.filterChain.setAttribute(this, AttributeId.Executable, executable);
    }

    public void setUserExecutable(Boolean userExecutable) {
        this.filterChain.setAttribute(this, AttributeId.UserExecutable, userExecutable);
    }

    @Override
    public synchronized Object getAttribute(AttributeId attributeId) {
        switch (attributeId) {
            case Executable: {
                return this.executable;
            }
            case UserExecutable: {
                return this.userExecutable;
            }
        }
        return super.getAttribute(attributeId);
    }

    @Override
    public synchronized void setAttribute(AttributeId attributeId, Object value) {
        switch (attributeId) {
            case Executable: {
                this.executable = (Boolean)value;
                break;
            }
            case UserExecutable: {
                this.userExecutable = (Boolean)value;
                break;
            }
            default: {
                super.setAttribute(attributeId, value);
                return;
            }
        }
        this.fireAttributeChanged(attributeId, value);
    }

    public List<Node> getPropertyNodes() {
        return this.getReferences().stream().filter(Reference.HAS_PROPERTY_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public Optional<ObjectNode> getModellingRuleNode() {
        Node node = this.getReferences().stream().filter(Reference.HAS_MODELLING_RULE_PREDICATE).findFirst().flatMap(r -> this.getManagedNode(r.getTargetNodeId())).orElse(null);
        ObjectNode objectNode = node instanceof ObjectNode ? (ObjectNode)node : null;
        return Optional.ofNullable(objectNode);
    }

    public List<Node> getAlwaysGeneratesEventNodes() {
        return this.getReferences().stream().filter(Reference.ALWAYS_GENERATES_EVENT_PREDICATE).flatMap(r -> StreamUtil.opt2stream(this.getManagedNode(r.getTargetNodeId()))).collect(Collectors.toList());
    }

    public MethodInvocationHandler getInvocationHandler() {
        return this.handler;
    }

    public void setInvocationHandler(MethodInvocationHandler handler) {
        this.handler = handler;
    }

    @Nullable
    public String getNodeVersion() {
        return this.getProperty(MethodNodeProperties.NodeVersion).orElse(null);
    }

    @Nullable
    public Argument[] getInputArguments() {
        return this.getProperty(MethodNodeProperties.InputArguments).orElse(null);
    }

    @Nullable
    public Argument[] getOutputArguments() {
        return this.getProperty(MethodNodeProperties.OutputArguments).orElse(null);
    }

    public void setNodeVersion(String nodeVersion) {
        this.setProperty(MethodNodeProperties.NodeVersion, nodeVersion);
    }

    public void setInputArguments(Argument[] inputArguments) {
        this.setProperty(MethodNodeProperties.InputArguments, inputArguments);
    }

    public void setOutputArguments(Argument[] outputArguments) {
        this.setProperty(MethodNodeProperties.OutputArguments, outputArguments);
    }

    public static UaMethodNodeBuilder builder(UaNodeContext context) {
        return new UaMethodNodeBuilder(context);
    }

    public static UaMethodNode build(UaNodeContext context, Function<UaMethodNodeBuilder, UaMethodNode> build) {
        UaMethodNodeBuilder builder = new UaMethodNodeBuilder(context);
        return build.apply(builder);
    }

    public static class UaMethodNodeBuilder
    implements Supplier<UaMethodNode> {
        private final List<AttributeFilter> attributeFilters = new ArrayList<AttributeFilter>();
        private final List<Reference> references = new ArrayList<Reference>();
        private NodeId nodeId;
        private QualifiedName browseName;
        private LocalizedText displayName;
        private LocalizedText description = LocalizedText.NULL_VALUE;
        private UInteger writeMask = UInteger.MIN;
        private UInteger userWriteMask = UInteger.MIN;
        private boolean executable = true;
        private boolean userExecutable = true;
        private final UaNodeContext context;

        public UaMethodNodeBuilder(UaNodeContext context) {
            this.context = context;
        }

        @Override
        public UaMethodNode get() {
            return this.build();
        }

        public UaMethodNode build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"NodeId cannot be null");
            Preconditions.checkNotNull((Object)this.browseName, (Object)"BrowseName cannot be null");
            Preconditions.checkNotNull((Object)this.displayName, (Object)"DisplayName cannot be null");
            UaMethodNode node = new UaMethodNode(this.context, this.nodeId, this.browseName, this.displayName, this.description, this.writeMask, this.userWriteMask, this.executable, this.userExecutable);
            this.references.forEach(node::addReference);
            node.getFilterChain().addLast(this.attributeFilters);
            return node;
        }

        public UaMethodNode buildAndAdd() {
            UaMethodNode node = this.build();
            this.context.getNodeManager().addNode(node);
            return node;
        }

        public UaMethodNodeBuilder setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public UaMethodNodeBuilder setBrowseName(QualifiedName browseName) {
            this.browseName = browseName;
            return this;
        }

        public UaMethodNodeBuilder setDisplayName(LocalizedText displayName) {
            this.displayName = displayName;
            return this;
        }

        public UaMethodNodeBuilder setDescription(LocalizedText description) {
            this.description = description;
            return this;
        }

        public UaMethodNodeBuilder setWriteMask(UInteger writeMask) {
            this.writeMask = writeMask;
            return this;
        }

        public UaMethodNodeBuilder setUserWriteMask(UInteger userWriteMask) {
            this.userWriteMask = userWriteMask;
            return this;
        }

        public UaMethodNodeBuilder setExecutable(boolean executable) {
            this.executable = executable;
            return this;
        }

        public UaMethodNodeBuilder setUserExecutable(boolean userExecutable) {
            this.userExecutable = userExecutable;
            return this;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public QualifiedName getBrowseName() {
            return this.browseName;
        }

        public LocalizedText getDisplayName() {
            return this.displayName;
        }

        public LocalizedText getDescription() {
            return this.description;
        }

        public UInteger getWriteMask() {
            return this.writeMask;
        }

        public UInteger getUserWriteMask() {
            return this.userWriteMask;
        }

        public boolean isExecutable() {
            return this.executable;
        }

        public boolean isUserExecutable() {
            return this.userExecutable;
        }

        public UaMethodNodeBuilder addAttributeFilter(AttributeFilter attributeFilter) {
            this.attributeFilters.add(attributeFilter);
            return this;
        }

        public UaMethodNodeBuilder addReference(Reference reference) {
            this.references.add(reference);
            return this;
        }
    }
}

