/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.utils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricInfo {
    private static final Logger logger = LoggerFactory.getLogger(MetricInfo.class);
    private static final Integer PAIR_SIZE = 2;
    private final String name;
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private final MetaInfo metaInfo;

    public MetricInfo(MetricType type, String name, String ... tags) {
        this.name = name;
        if (tags.length % PAIR_SIZE == 0) {
            for (int i = 0; i < tags.length; i += PAIR_SIZE.intValue()) {
                this.tags.put(tags[i], tags[i + 1]);
            }
        } else {
            logger.error("The size of metric tags should be even, but was odd, tags: {}.", (Object)String.join((CharSequence)",", tags));
        }
        this.metaInfo = new MetaInfo(type, this.tags.keySet());
    }

    public String getName() {
        return this.name;
    }

    public String[] getTagsInArray() {
        String[] tags = new String[this.tags.size() * 2];
        int index = 0;
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            tags[index++] = entry.getKey();
            tags[index++] = entry.getValue();
        }
        return tags;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public Pair<String, String[]> toStringArray() {
        ArrayList allNames = new ArrayList();
        this.tags.forEach((k, v) -> {
            allNames.add(k);
            allNames.add(v);
        });
        return new Pair((Object)this.name, (Object)allNames.toArray(new String[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricInfo that = (MetricInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (that.getTags().size() != this.tags.size()) {
            return false;
        }
        Map<String, String> thatTags = that.getTags();
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            if (!thatTags.containsKey(entry.getKey())) {
                return false;
            }
            if (thatTags.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tags);
    }

    public String toString() {
        return "MetricInfo{name='" + this.name + '\'' + ", metaInfo=" + this.metaInfo + ", tags=" + this.tags + '}';
    }

    public static class MetaInfo {
        private final MetricType type;
        private final Set<String> tagNames;

        public MetaInfo(MetricType type, Set<String> tagNames) {
            this.type = type;
            this.tagNames = tagNames;
        }

        public boolean hasSameKey(String ... tags) {
            if (tags.length != this.tagNames.size() * 2) {
                return false;
            }
            for (int i = 0; i < tags.length; i += PAIR_SIZE.intValue()) {
                if (this.tagNames.contains(tags[i])) continue;
                return false;
            }
            return true;
        }

        public MetricType getType() {
            return this.type;
        }

        public Set<String> getTagNames() {
            return this.tagNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaInfo that = (MetaInfo)o;
            if (this.tagNames == null || that.tagNames == null) {
                return false;
            }
            for (String tagName : that.tagNames) {
                if (this.tagNames.contains(tagName)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.tagNames);
        }

        public String toString() {
            return "MetaInfo{type=" + (Object)((Object)this.type) + ", tagNames=" + this.tagNames + '}';
        }
    }
}

