/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.james.core.Username;
import org.apache.james.webadmin.dto.QuotaDetailsDTO;

public class UsersQuotaDetailsDTO {
    private static final String USERNAME = "username";
    private final Username username;
    private final QuotaDetailsDTO detail;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    UsersQuotaDetailsDTO(Username username, QuotaDetailsDTO detail) {
        this.username = username;
        this.detail = detail;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username.asString();
    }

    public QuotaDetailsDTO getDetail() {
        return this.detail;
    }

    public static class Builder {
        private Username username;
        private QuotaDetailsDTO detail;

        private Builder() {
        }

        public Builder user(Username username) {
            this.username = username;
            return this;
        }

        public Builder detail(QuotaDetailsDTO detail) {
            this.detail = detail;
            return this;
        }

        public UsersQuotaDetailsDTO build() {
            Preconditions.checkNotNull((Object)this.username);
            Preconditions.checkNotNull((Object)this.detail);
            return new UsersQuotaDetailsDTO(this.username, this.detail);
        }
    }
}

