/*
 * Decompiled with CFR 0.152.
 */
package tdb2.xloader;

import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.tdb2.xloader.ProcBuildIndexX;
import tdb2.xloader.AbstractCmdxLoad;

public class CmdxBuildIndex
extends AbstractCmdxLoad {
    public static void main(String ... args) {
        new CmdxBuildIndex(args).mainRun();
    }

    protected CmdxBuildIndex(String[] argv) {
        super("Index", argv);
    }

    @Override
    protected void setCmdArgs() {
        super.add(argLocation, "--loc=", "Database location");
        super.add(argTmpdir, "--tmpdir=", "Temporary directory (defaults to --loc)");
        super.add(argIndex, "--index=", "Index name");
        super.add(argSortThreads, "--threads=", "Number of threads; passed as an argument to sort(1)");
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + this.getArgsSummary();
    }

    @Override
    protected String getArgsSummary() {
        return super.getArgsSummary() + " --index=NAME";
    }

    @Override
    protected void subCheckArgs() {
        if (this.location == null) {
            throw new CmdException("Required : --loc");
        }
        if (this.indexName == null) {
            throw new CmdException("Required : --index");
        }
    }

    @Override
    protected String getCommandName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    protected void exec() {
        FileOps.ensureDir(this.location);
        if (this.tmpdir == null) {
            this.tmpdir = this.location;
        }
        ProcBuildIndexX.exec(this.location, this.indexName, this.sortThreads, this.sortIndexArgs, this.loaderFiles);
    }
}

