/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.rss.Entry;
import org.apache.wiki.rss.Feed;
import org.apache.wiki.util.XhtmlUtil;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class RSS10Feed
extends Feed {
    private static final Namespace NS_XMNLS = Namespace.getNamespace((String)"http://purl.org/rss/1.0/");
    private static final Namespace NS_RDF = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    private static final Namespace NS_DC = Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/");
    private static final Namespace NS_WIKI = Namespace.getNamespace((String)"wiki", (String)"http://purl.org/rss/1.0/modules/wiki/");

    public RSS10Feed(Context context) {
        super(context);
    }

    private Element getRDFItems() {
        Element items = new Element("items", NS_XMNLS);
        Element rdfseq = new Element("Seq", NS_RDF);
        for (Entry e : this.m_entries) {
            String url = e.getURL();
            rdfseq.addContent((Content)new Element("li", NS_RDF).setAttribute("resource", url, NS_RDF));
        }
        items.addContent((Content)rdfseq);
        return items;
    }

    private void addItemList(Element root) {
        SimpleDateFormat iso8601fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Engine engine = this.m_wikiContext.getEngine();
        for (Entry entry : this.m_entries) {
            String url = entry.getURL();
            Element item = new Element("item", NS_XMNLS);
            item.setAttribute("about", url, NS_RDF);
            item.addContent((Content)new Element("title", NS_XMNLS).addContent(entry.getTitle()));
            item.addContent((Content)new Element("link", NS_XMNLS).addContent(url));
            Element content = new Element("description", NS_XMNLS);
            content.addContent(entry.getContent());
            item.addContent((Content)content);
            Page p = entry.getPage();
            if (p.getVersion() != -1) {
                item.addContent((Content)new Element("version", NS_WIKI).addContent(Integer.toString(p.getVersion())));
            }
            if (p.getVersion() > 1) {
                item.addContent((Content)new Element("diff", NS_WIKI).addContent(engine.getURL(ContextEnum.PAGE_DIFF.getRequestContext(), p.getName(), "r1=-1")));
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(p.getLastModified());
            cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(p.getLastModified()) ? cal.get(16) : 0)));
            item.addContent((Content)new Element("date", NS_DC).addContent(iso8601fmt.format(cal.getTime())));
            String author = entry.getAuthor();
            if (author == null) {
                author = "unknown";
            }
            Element contributor = new Element("creator", NS_DC);
            item.addContent((Content)contributor);
            contributor.addContent(author);
            item.addContent((Content)new Element("history", NS_WIKI).addContent(engine.getURL(ContextEnum.PAGE_INFO.getRequestContext(), p.getName(), null)));
            root.addContent((Content)item);
        }
    }

    private Element getChannelElement() {
        Element channel = new Element("channel", NS_XMNLS);
        channel.setAttribute("about", this.m_feedURL, NS_RDF).addContent((Content)new Element("link", NS_XMNLS).addContent(this.m_feedURL));
        if (this.m_channelTitle != null) {
            channel.addContent((Content)new Element("title", NS_XMNLS).addContent(this.m_channelTitle));
        }
        if (this.m_channelDescription != null) {
            channel.addContent((Content)new Element("description", NS_XMNLS).addContent(this.m_channelDescription));
        }
        if (this.m_channelLanguage != null) {
            channel.addContent((Content)new Element("language", NS_DC).addContent(this.m_channelLanguage));
        }
        channel.addContent((Content)this.getRDFItems());
        return channel;
    }

    @Override
    public String getString() {
        Element root = new Element("RDF", NS_RDF);
        root.addContent((Content)this.getChannelElement());
        root.addNamespaceDeclaration(NS_XMNLS);
        root.addNamespaceDeclaration(NS_RDF);
        root.addNamespaceDeclaration(NS_DC);
        root.addNamespaceDeclaration(NS_WIKI);
        this.addItemList(root);
        return XhtmlUtil.serialize((Element)root, (boolean)true);
    }
}

