/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.url;

import java.nio.charset.Charset;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.wiki.api.core.Command;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.ui.CommandResolver;
import org.apache.wiki.url.URLConstructor;
import org.apache.wiki.util.TextUtil;

public class DefaultURLConstructor
implements URLConstructor {
    protected Engine m_engine;
    protected String m_pathPrefix = "";

    public void initialize(Engine engine, Properties properties) {
        this.m_engine = engine;
        this.m_pathPrefix = engine.getBaseURL() + "/";
    }

    protected final String doReplacement(String baseptrn, String name) {
        String baseurl = this.m_pathPrefix;
        baseptrn = TextUtil.replaceString((String)baseptrn, (String)"%u", (String)baseurl);
        baseptrn = TextUtil.replaceString((String)baseptrn, (String)"%U", (String)this.m_engine.getBaseURL());
        baseptrn = TextUtil.replaceString((String)baseptrn, (String)"%n", (String)this.encodeURI(name));
        baseptrn = TextUtil.replaceString((String)baseptrn, (String)"%p", (String)this.m_pathPrefix);
        return baseptrn;
    }

    private String encodeURI(String uri) {
        uri = this.m_engine.encodeName(uri);
        uri = StringUtils.replace((String)uri, (String)"+", (String)"%20");
        uri = StringUtils.replace((String)uri, (String)"%2F", (String)"/");
        return uri;
    }

    public static String getURLPattern(String context, String name) throws IllegalArgumentException {
        if (context.equals(ContextEnum.PAGE_VIEW.getRequestContext()) && name == null) {
            return "%uWiki.jsp";
        }
        Command command = CommandResolver.findCommand(context);
        return command.getURLPattern();
    }

    private String makeURL(String context, String name) {
        return this.doReplacement(DefaultURLConstructor.getURLPattern(context, name), name);
    }

    @Override
    public String makeURL(String context, String name, String parameters) {
        parameters = parameters != null && !((String)parameters).isEmpty() ? (context.equals(ContextEnum.PAGE_ATTACH.getRequestContext()) ? "?" + (String)parameters : (context.equals(ContextEnum.PAGE_NONE.getRequestContext()) ? (name.indexOf(63) != -1 ? "&amp;" : "?" + (String)parameters) : "&amp;" + (String)parameters)) : "";
        return this.makeURL(context, name) + (String)parameters;
    }

    @Override
    public String parsePage(String context, HttpServletRequest request, Charset encoding) {
        String pagereq = request.getParameter("page");
        if (context.equals(ContextEnum.PAGE_ATTACH.getRequestContext())) {
            pagereq = URLConstructor.parsePageFromURL(request, encoding);
        }
        return pagereq;
    }

    @Override
    public String getForwardPage(HttpServletRequest request) {
        return "Wiki.jsp";
    }
}

