/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.xmlrpc;

import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.Context;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.api.spi.Wiki;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthenticationManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.pages.PageManager;
import org.apache.wiki.pages.PageTimeComparator;
import org.apache.wiki.plugin.WeblogEntryPlugin;
import org.apache.wiki.plugin.WeblogPlugin;
import org.apache.wiki.xmlrpc.WikiRPCHandler;
import org.apache.xmlrpc.XmlRpcException;

public class MetaWeblogHandler
implements WikiRPCHandler {
    private static final Logger LOG = LogManager.getLogger(MetaWeblogHandler.class);
    private Context m_context;

    @Override
    public void initialize(Context context) {
        this.m_context = context;
    }

    private void checkPermissions(Page page, String username, String password, String permission) throws XmlRpcException {
        block4: {
            try {
                AuthenticationManager amm = (AuthenticationManager)this.m_context.getEngine().getManager(AuthenticationManager.class);
                AuthorizationManager mgr = (AuthorizationManager)this.m_context.getEngine().getManager(AuthorizationManager.class);
                if (amm.login(this.m_context.getWikiSession(), this.m_context.getHttpRequest(), username, password)) {
                    if (!mgr.checkPermission(this.m_context.getWikiSession(), PermissionFactory.getPagePermission(page, permission))) {
                        throw new XmlRpcException(1, "No permission");
                    }
                    break block4;
                }
                throw new XmlRpcException(1, "Unknown login");
            }
            catch (WikiSecurityException e) {
                throw new XmlRpcException(1, e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    public Hashtable<Object, Object> getCategories(String blogid, String username, String password) throws XmlRpcException {
        Page page = ((PageManager)this.m_context.getEngine().getManager(PageManager.class)).getPage(blogid);
        this.checkPermissions(page, username, password, "view");
        return new Hashtable<Object, Object>();
    }

    private String getURL(String page) {
        return this.m_context.getEngine().getURL(ContextEnum.PAGE_VIEW.getRequestContext(), page, null);
    }

    private Hashtable<String, Object> makeEntry(Page page) {
        Page firstVersion = ((PageManager)this.m_context.getEngine().getManager(PageManager.class)).getPage(page.getName(), 1);
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("dateCreated", firstVersion.getLastModified());
        ht.put("link", this.getURL(page.getName()));
        ht.put("permaLink", this.getURL(page.getName()));
        ht.put("postid", page.getName());
        ht.put("userid", page.getAuthor());
        String pageText = ((PageManager)this.m_context.getEngine().getManager(PageManager.class)).getText(page.getName());
        int firstLine = pageText.indexOf(10);
        String title = "";
        if (firstLine > 0) {
            title = pageText.substring(0, firstLine);
        }
        if (title.trim().isEmpty()) {
            title = page.getName();
        }
        while (title.startsWith("!")) {
            title = title.substring(1);
        }
        ht.put("title", title);
        ht.put("description", pageText);
        return ht;
    }

    public Hashtable getRecentPosts(String blogid, String username, String password, int numberOfPosts) throws XmlRpcException {
        Hashtable<String, Hashtable<String, Object>> result = new Hashtable<String, Hashtable<String, Object>>();
        LOG.info("metaWeblog.getRecentPosts() called");
        Page page = ((PageManager)this.m_context.getEngine().getManager(PageManager.class)).getPage(blogid);
        this.checkPermissions(page, username, password, "view");
        WeblogPlugin plugin = new WeblogPlugin();
        List<Page> changed = plugin.findBlogEntries(this.m_context.getEngine(), blogid, new Date(0L), new Date());
        changed.sort(new PageTimeComparator());
        Iterator<Page> i = changed.iterator();
        for (int items = 0; i.hasNext() && items < numberOfPosts; ++items) {
            Page p = i.next();
            result.put("entry", this.makeEntry(p));
        }
        return result;
    }

    public String newPost(String blogid, String username, String password, Hashtable<String, Object> content, boolean publish) throws XmlRpcException {
        LOG.info("metaWeblog.newPost() called");
        Engine engine = this.m_context.getEngine();
        Page page = ((PageManager)engine.getManager(PageManager.class)).getPage(blogid);
        this.checkPermissions(page, username, password, "createPages");
        try {
            WeblogEntryPlugin plugin = new WeblogEntryPlugin();
            String pageName = plugin.getNewEntryPage(engine, blogid);
            Page entryPage = Wiki.contents().page(engine, pageName);
            entryPage.setAuthor(username);
            Context context = Wiki.context().create(engine, entryPage);
            StringBuilder text = new StringBuilder();
            text.append("!").append(content.get("title"));
            text.append("\n\n");
            text.append(content.get("description"));
            LOG.debug("Writing entry: " + text);
            ((PageManager)engine.getManager(PageManager.class)).saveText(context, text.toString());
        }
        catch (Exception e) {
            LOG.error("Failed to create weblog entry", (Throwable)e);
            throw new XmlRpcException(0, "Failed to create weblog entry: " + e.getMessage());
        }
        return "";
    }

    public Hashtable<String, Object> newMediaObject(String blogid, String username, String password, Hashtable<String, Object> content) throws XmlRpcException {
        String url;
        Engine engine = this.m_context.getEngine();
        LOG.info("metaWeblog.newMediaObject() called");
        Page page = ((PageManager)engine.getManager(PageManager.class)).getPage(blogid);
        this.checkPermissions(page, username, password, "upload");
        String name = (String)content.get("name");
        byte[] data = (byte[])content.get("bits");
        AttachmentManager attmgr = (AttachmentManager)engine.getManager(AttachmentManager.class);
        try {
            Attachment att = Wiki.contents().attachment(engine, blogid, name);
            att.setAuthor(username);
            attmgr.storeAttachment(att, new ByteArrayInputStream(data));
            url = engine.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), att.getName(), null);
        }
        catch (Exception e) {
            LOG.error("Failed to upload attachment", (Throwable)e);
            throw new XmlRpcException(0, "Failed to upload media object: " + e.getMessage());
        }
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("url", url);
        return result;
    }

    boolean editPost(String postid, String username, String password, Hashtable<String, Object> content, boolean publish) throws XmlRpcException {
        Engine engine = this.m_context.getEngine();
        LOG.info("metaWeblog.editPost(" + postid + ") called");
        Page page = ((PageManager)engine.getManager(PageManager.class)).getPage(postid);
        this.checkPermissions(page, username, password, "edit");
        try {
            Page entryPage = page.clone();
            entryPage.setAuthor(username);
            Context context = Wiki.context().create(engine, entryPage);
            StringBuilder text = new StringBuilder();
            text.append("!").append(content.get("title"));
            text.append("\n\n");
            text.append(content.get("description"));
            LOG.debug("Updating entry: " + text);
            ((PageManager)engine.getManager(PageManager.class)).saveText(context, text.toString());
        }
        catch (Exception e) {
            LOG.error("Failed to create weblog entry", (Throwable)e);
            throw new XmlRpcException(0, "Failed to update weblog entry: " + e.getMessage());
        }
        return true;
    }

    Hashtable<String, Object> getPost(String postid, String username, String password) throws XmlRpcException {
        String wikiname = "FIXME";
        Page page = ((PageManager)this.m_context.getEngine().getManager(PageManager.class)).getPage("FIXME");
        this.checkPermissions(page, username, password, "view");
        return this.makeEntry(page);
    }
}

