/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Set;
import org.apache.juneau.bean.openapi3.Contact;
import org.apache.juneau.bean.openapi3.License;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Info
extends OpenApiElement {
    private String title;
    private String description;
    private String termsOfService;
    private String version;
    private Contact contact;
    private License license;

    public Info() {
    }

    public Info(Info copyFrom) {
        super(copyFrom);
        this.title = copyFrom.title;
        this.description = copyFrom.description;
        this.termsOfService = copyFrom.termsOfService;
        this.version = copyFrom.version;
        this.contact = copyFrom.contact == null ? null : copyFrom.contact.copy();
        this.license = copyFrom.license == null ? null : copyFrom.license.copy();
    }

    public Info copy() {
        return new Info(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "title" -> ConverterUtils.toType((Object)this.getTitle(), type);
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "termsOfService" -> ConverterUtils.toType((Object)this.getTermsOfService(), type);
            case "contact" -> ConverterUtils.toType((Object)this.getContact(), type);
            case "license" -> ConverterUtils.toType((Object)this.getLicense(), type);
            case "version" -> ConverterUtils.toType((Object)this.getVersion(), type);
            default -> super.get(property, type);
        });
    }

    public Contact getContact() {
        return this.contact;
    }

    public String getDescription() {
        return this.description;
    }

    public License getLicense() {
        return this.license;
    }

    public String getTermsOfService() {
        return this.termsOfService;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.contact), (Object)"contact").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.nn((Object)this.license), (Object)"license").addIf(Utils.nn((Object)this.termsOfService), (Object)"termsOfService").addIf(Utils.nn((Object)this.title), (Object)"title").addIf(Utils.nn((Object)this.version), (Object)"version").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public Info set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "contact" -> this.setContact((Contact)ConverterUtils.toType((Object)value, Contact.class));
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "license" -> this.setLicense((License)ConverterUtils.toType((Object)value, License.class));
            case "termsOfService" -> this.setTermsOfService(Utils.s((Object)value));
            case "title" -> this.setTitle(Utils.s((Object)value));
            case "version" -> this.setVersion(Utils.s((Object)value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Info setContact(Contact value) {
        this.contact = value;
        return this;
    }

    public Info setDescription(String value) {
        this.description = value;
        return this;
    }

    public Info setLicense(License value) {
        this.license = value;
        return this;
    }

    public Info setTermsOfService(String value) {
        this.termsOfService = value;
        return this;
    }

    public Info setTitle(String value) {
        this.title = value;
        return this;
    }

    public Info setVersion(String value) {
        this.version = value;
        return this;
    }

    @Override
    public Info strict() {
        super.strict();
        return this;
    }

    @Override
    public Info strict(Object value) {
        super.strict(value);
        return this;
    }
}

