/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.Arrays;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.table.ShellTable;

@Command(scope="feature", name="version-list", description="Lists all versions of a feature available from the currently available repositories.")
public class ListFeatureVersionsCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="feature", description="Name of feature.", required=true, multiValued=false)
    String feature;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    @Override
    protected void doExecute(FeaturesService admin) throws Exception {
        ShellTable table = new ShellTable();
        table.column("Version");
        table.column("Repository");
        table.column("Repository URL");
        table.emptyTableText("No versions available for features '" + this.feature + "'");
        for (Repository r : Arrays.asList(admin.listRepositories())) {
            for (Feature f : r.getFeatures()) {
                if (!f.getName().equals(this.feature)) continue;
                table.addRow().addContent(new Object[]{f.getVersion(), r.getName(), r.getURI()});
            }
        }
        table.print(System.out, !this.noFormat);
    }
}

