/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.region.commands;

import java.util.List;
import org.apache.karaf.region.commands.RegionCommandSupport;
import org.apache.karaf.region.persist.RegionsPersistence;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;

@Command(scope="region", name="bundle-add", description="Adds a list of known bundles by id to a specified region.")
public class AddBundleCommand
extends RegionCommandSupport {
    @Argument(index=0, name="region", description="Region to add the bundles to", required=true, multiValued=false)
    String region;
    @Argument(index=1, name="bundles", description="Bundles by id to add to the region", required=true, multiValued=true)
    List<Long> ids;

    @Override
    protected void doExecute(RegionDigraph regionDigraph, RegionsPersistence persist) throws Exception {
        Region r = this.getRegion(regionDigraph, this.region);
        if (!this.ids.isEmpty()) {
            for (Long id : this.ids) {
                for (Region existing : regionDigraph.getRegions()) {
                    if (!existing.contains(id.longValue())) continue;
                    Bundle b = this.getBundleContext().getBundle(id.longValue());
                    System.out.println("Removing bundle " + id + " from region " + existing.getName());
                    existing.removeBundle(b);
                    break;
                }
                r.addBundle(id.longValue());
            }
            persist.save();
        }
    }
}

