/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.component;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.TimeUtils;

public abstract class PropertyConfigurerSupport {
    public static <T> T property(CamelContext camelContext, Class<T> type, Object value) {
        String text;
        if (value instanceof String && String.class != type) {
            text = value.toString();
            if (EndpointHelper.isReferenceParameter(text)) {
                List<Object> obj = type == List.class ? EndpointHelper.resolveReferenceListParameter(camelContext, text, Object.class) : EndpointHelper.resolveReferenceParameter(camelContext, text, type);
                if (obj == null) {
                    throw new NoSuchBeanException(text, type.getName());
                }
                value = obj;
            } else if (type == Long.TYPE || type == Long.class || type == Integer.TYPE || type == Integer.class) {
                Number obj = null;
                try {
                    long num = TimeUtils.toMilliSeconds((String)text);
                    obj = type == Integer.TYPE || type == Integer.class ? (Number)((int)num) : (Number)num;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (obj != null) {
                    value = obj;
                }
            }
        }
        if (!(type != Boolean.class && type != Boolean.TYPE || !(value instanceof String) || (text = (String)((Object)value)).equalsIgnoreCase("true") || text.equalsIgnoreCase("false"))) {
            throw new IllegalArgumentException("Cannot convert the String value: " + value + " to type: " + type + " as the value is not true or false");
        }
        return (T)camelContext.getTypeConverter().convertTo(type, (Object)value);
    }
}

