/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.service.FeaturesProcessor;
import org.apache.karaf.features.internal.service.RepositoryCache;
import org.apache.karaf.features.internal.service.RepositoryImpl;

public class RepositoryCacheImpl
implements RepositoryCache {
    private final Map<String, Repository> repositoryCache = new HashMap<String, Repository>();
    private final FeaturesProcessor featuresProcessor;

    public RepositoryCacheImpl(FeaturesProcessor featuresProcessor) {
        this.featuresProcessor = featuresProcessor;
    }

    @Override
    public Repository create(URI uri, boolean validate) {
        if (this.featuresProcessor != null && this.featuresProcessor.isRepositoryBlacklisted(uri.toString())) {
            return new RepositoryImpl(uri, new Features(), true);
        }
        RepositoryImpl repository = new RepositoryImpl(uri, validate);
        if (this.featuresProcessor != null) {
            repository.setBlacklisted(this.featuresProcessor.isRepositoryBlacklisted(uri.toString()));
            repository.processFeatures(this.featuresProcessor);
        }
        return repository;
    }

    @Override
    public void addRepository(Repository repository) {
        String repoUriSt = repository.getURI().toString();
        this.repositoryCache.put(repoUriSt, repository);
    }

    @Override
    public void removeRepository(URI repositoryUri) {
        ArrayList<String> toRemove = new ArrayList<String>();
        toRemove.add(repositoryUri.toString());
        while (!toRemove.isEmpty()) {
            Repository rep = this.repositoryCache.remove(toRemove.remove(0));
            if (rep == null) continue;
            for (URI u : rep.getRepositories()) {
                toRemove.add(u.toString());
            }
        }
    }

    @Override
    public Repository[] listRepositories() {
        return this.repositoryCache.values().toArray(new Repository[this.repositoryCache.size()]);
    }

    @Override
    public Repository[] listMatchingRepositories(Set<String> uris) {
        return (Repository[])this.repositoryCache.values().stream().filter(r -> uris.contains(r.getURI().toString())).toArray(Repository[]::new);
    }

    @Override
    public Repository getRepositoryByName(String name) {
        for (Repository repo : this.repositoryCache.values()) {
            if (!name.equals(repo.getName())) continue;
            return repo;
        }
        return null;
    }

    @Override
    public Repository getRepository(String uri) {
        return this.repositoryCache.get(uri);
    }

    @Override
    public Set<Repository> getRepositoryClosure(Repository repo) {
        HashSet<Repository> closure = new HashSet<Repository>();
        ArrayDeque<Repository> remaining = new ArrayDeque<Repository>(Collections.singleton(repo));
        while (!remaining.isEmpty()) {
            Repository rep = (Repository)remaining.removeFirst();
            if (!closure.add(rep)) continue;
            for (URI uri : rep.getRepositories()) {
                remaining.add(this.getRepository(uri.toString()));
            }
        }
        return closure;
    }
}

