/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;

public class DelayInducingInterceptor
extends BaseInterceptor {
    private Long delayMillis;

    public DelayInducingInterceptor() {
        super("DelayInterceptor");
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        EntryFilteringCursor cursor = this.next(searchContext);
        cursor.addEntryFilter(new EntryFilter(){

            @Override
            public boolean accept(SearchOperationContext operation, Entry result) throws LdapException {
                if (DelayInducingInterceptor.this.delayMillis != null) {
                    try {
                        Thread.sleep(DelayInducingInterceptor.this.delayMillis);
                    }
                    catch (InterruptedException ie) {
                        throw new LdapOperationErrorException(ie.getMessage());
                    }
                }
                return true;
            }

            @Override
            public String toString(String tabs) {
                return tabs + "DelayInducingFilter";
            }
        });
        return cursor;
    }

    public void setDelayMillis(long delayMillis) {
        if (delayMillis <= 0L) {
            this.delayMillis = null;
        }
        this.delayMillis = delayMillis;
    }
}

