/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.io.IOException;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.avltree.ArrayTree;
import org.apache.directory.server.core.avltree.ArrayTreeCursor;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyTupleArrayCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final ArrayTreeCursor<V> wrapped;
    private final K key;
    private Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public KeyTupleArrayCursor(ArrayTree<V> arrayTree, K key) {
        this.key = key;
        this.wrapped = new ArrayTreeCursor<V>(arrayTree);
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating KeyTupleArrayCursor {}", (Object)this);
        }
    }

    private void clearValue() {
        this.returnedTuple.setKey(this.key);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    public void afterKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    public void beforeValue(K key, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
        }
        this.wrapped.before(value);
        this.clearValue();
    }

    public void afterValue(K key, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
        }
        this.wrapped.after(value);
        this.clearValue();
    }

    @Override
    public void before(Tuple<K, V> element) throws LdapException, CursorException {
        this.checkNotClosed("before()");
        this.wrapped.before(element.getValue());
        this.clearValue();
    }

    @Override
    public void after(Tuple<K, V> element) throws LdapException, CursorException {
        this.checkNotClosed("after()");
        this.wrapped.after(element.getValue());
        this.clearValue();
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
        this.clearValue();
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.clearValue();
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed("previous()");
        if (this.wrapped.previous()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed("next()");
        if (this.wrapped.next()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public Tuple<K, V> get() throws CursorException {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleArrayCursor {}", (Object)this);
        }
        if (this.wrapped != null) {
            this.wrapped.close();
        }
        super.close();
    }

    @Override
    public void close(Exception reason) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing KeyTupleArrayCursor {}", (Object)this);
        }
        if (this.wrapped != null) {
            this.wrapped.close(reason);
        }
        super.close(reason);
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("KeyTupleArrayCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#").append(this.key);
        sb.append(" :\n");
        sb.append(this.wrapped.toString(tabs + "    "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

