/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.deploy.ServiceDeploymentContributor;
import org.apache.knox.gateway.deploy.impl.ServiceDefinitionDeploymentContributor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptorFactory;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.definition.ServiceDefinition;

public class ServiceDefinitionsLoader {
    private static final GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final String SERVICE_FILE_NAME = "service";
    private static final String REWRITE_FILE = "rewrite.xml";

    public static Set<ServiceDeploymentContributor> loadServiceDefinitions(File servicesDir) {
        HashSet<ServiceDeploymentContributor> contributors = new HashSet<ServiceDeploymentContributor>();
        if (servicesDir.exists() && servicesDir.isDirectory()) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ServiceDefinition.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                for (File file : ServiceDefinitionsLoader.getFileList(servicesDir)) {
                    try {
                        FileInputStream inputStream = new FileInputStream(file);
                        ServiceDefinition definition = (ServiceDefinition)unmarshaller.unmarshal((InputStream)inputStream);
                        UrlRewriteRulesDescriptor rewriteRulesDescriptor = ServiceDefinitionsLoader.loadRewriteRules(file.getParentFile());
                        contributors.add((ServiceDeploymentContributor)new ServiceDefinitionDeploymentContributor(definition, rewriteRulesDescriptor));
                        log.addedServiceDefinition(definition.getName(), definition.getRole(), definition.getVersion());
                    }
                    catch (FileNotFoundException e) {
                        log.failedToFindServiceDefinitionFile(file.getAbsolutePath(), e);
                    }
                }
            }
            catch (JAXBException e) {
                log.failedToLoadServiceDefinition(SERVICE_FILE_NAME, (Exception)((Object)e));
            }
        }
        return contributors;
    }

    public static Set<ServiceDefinition> getServiceDefinitions(File servicesDir) {
        HashSet<ServiceDefinition> definitions = new HashSet<ServiceDefinition>();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ServiceDefinition.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            for (File f : ServiceDefinitionsLoader.getFileList(servicesDir)) {
                ServiceDefinition definition = (ServiceDefinition)unmarshaller.unmarshal(f);
                definitions.add(definition);
            }
        }
        catch (JAXBException e) {
            log.failedToLoadServiceDefinition(SERVICE_FILE_NAME, (Exception)((Object)e));
        }
        return definitions;
    }

    private static Collection<File> getFileList(File servicesDir) {
        Collection<File> files = servicesDir.exists() && servicesDir.isDirectory() ? FileUtils.listFiles((File)servicesDir, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return file.getName().contains(ServiceDefinitionsLoader.SERVICE_FILE_NAME);
            }

            public boolean accept(File dir, String name) {
                return name.contains(ServiceDefinitionsLoader.SERVICE_FILE_NAME);
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE) : new HashSet<File>();
        return files;
    }

    public static UrlRewriteRulesDescriptor loadRewriteRules(File servicesDir) {
        File rewriteFile = new File(servicesDir, REWRITE_FILE);
        if (rewriteFile.exists()) {
            try {
                FileInputStream stream = new FileInputStream(rewriteFile);
                InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);
                UrlRewriteRulesDescriptor rules = UrlRewriteRulesDescriptorFactory.load((String)"xml", (Reader)reader);
                ((Reader)reader).close();
                ((InputStream)stream).close();
                return rules;
            }
            catch (FileNotFoundException e) {
                log.failedToFindRewriteFile(rewriteFile.getAbsolutePath(), e);
            }
            catch (IOException e) {
                log.failedToLoadRewriteFile(rewriteFile.getAbsolutePath(), e);
            }
        }
        log.noRewriteFileFound(servicesDir.getAbsolutePath());
        return null;
    }
}

