/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api;

import com.fasterxml.jackson.annotation.JsonFilter;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.catalog.api.EventAttribute;

@JsonFilter(value="catalogEvent")
public class Event
implements Serializable {
    private static final long serialVersionUID = 1512172827909901054L;
    private Long id;
    private String name;
    private String displayName;
    private String description;
    private Set<String> aliases;
    private String catalogId = "DEFAULT";
    private List<EventAttribute> attributes;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Event setName(String name) {
        this.name = name;
        return this;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Event setDisplayName(String name) {
        this.displayName = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Event setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public Event setCatalogId(String catalogId) {
        if (catalogId != null) {
            this.catalogId = catalogId;
        }
        return this;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Event setAliases(Set<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public List<EventAttribute> getAttributes() {
        return this.attributes;
    }

    public Event setAttributes(List<EventAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"name\" : \"").append(this.name).append("\", \"displayName\" : \"").append(this.displayName).append("\"");
        sb.append(", \"description\" : \"").append(this.description).append("\", \"attributes\" : [");
        boolean first = true;
        for (EventAttribute attribute : this.attributes) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append("{\"name\" : \"").append(attribute.getName()).append("\", \"required\" : ").append(attribute.isRequired()).append("}");
        }
        sb.append("]}");
        return sb.toString();
    }
}

