/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;

public class BlobStoreIndexShardSnapshots
implements Iterable<BlobStoreIndexShardSnapshot> {
    private final ImmutableList<BlobStoreIndexShardSnapshot> shardSnapshots;

    public BlobStoreIndexShardSnapshots(List<BlobStoreIndexShardSnapshot> shardSnapshots) {
        this.shardSnapshots = ImmutableList.copyOf(shardSnapshots);
    }

    public ImmutableList<BlobStoreIndexShardSnapshot> snapshots() {
        return this.shardSnapshots;
    }

    public BlobStoreIndexShardSnapshot.FileInfo findPhysicalIndexFile(String physicalName) {
        for (BlobStoreIndexShardSnapshot snapshot : this.shardSnapshots) {
            BlobStoreIndexShardSnapshot.FileInfo fileInfo = snapshot.findPhysicalIndexFile(physicalName);
            if (fileInfo == null) continue;
            return fileInfo;
        }
        return null;
    }

    public BlobStoreIndexShardSnapshot.FileInfo findNameFile(String name) {
        for (BlobStoreIndexShardSnapshot snapshot : this.shardSnapshots) {
            BlobStoreIndexShardSnapshot.FileInfo fileInfo = snapshot.findNameFile(name);
            if (fileInfo == null) continue;
            return fileInfo;
        }
        return null;
    }

    @Override
    public Iterator<BlobStoreIndexShardSnapshot> iterator() {
        return this.shardSnapshots.iterator();
    }
}

