/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceBased;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public abstract class ValueSourceAggregatorFactory<VS extends ValuesSource>
extends AggregatorFactory
implements ValuesSourceBased {
    protected ValuesSourceConfig<VS> valuesSourceConfig;

    protected ValueSourceAggregatorFactory(String name, String type, ValuesSourceConfig<VS> valuesSourceConfig) {
        super(name, type);
        this.valuesSourceConfig = valuesSourceConfig;
    }

    @Override
    public ValuesSourceConfig valuesSourceConfig() {
        return this.valuesSourceConfig;
    }

    @Override
    public Aggregator create(AggregationContext context, Aggregator parent, long expectedBucketsCount) {
        if (this.valuesSourceConfig.unmapped()) {
            return this.createUnmapped(context, parent);
        }
        VS vs = context.valuesSource(this.valuesSourceConfig, parent == null ? 0 : 1 + parent.depth());
        return this.create(vs, expectedBucketsCount, context, parent);
    }

    @Override
    public void doValidate() {
        if (this.valuesSourceConfig == null || !this.valuesSourceConfig.valid()) {
            this.valuesSourceConfig = ValueSourceAggregatorFactory.resolveValuesSourceConfigFromAncestors(this.name, this.parent, this.valuesSourceConfig.valueSourceType());
        }
    }

    protected abstract Aggregator createUnmapped(AggregationContext var1, Aggregator var2);

    protected abstract Aggregator create(VS var1, long var2, AggregationContext var4, Aggregator var5);

    private static <VS extends ValuesSource> ValuesSourceConfig<VS> resolveValuesSourceConfigFromAncestors(String aggName, AggregatorFactory parent, Class<VS> requiredValuesSourceType) {
        while (parent != null) {
            ValuesSourceConfig config;
            if (parent instanceof ValuesSourceBased && (config = ((ValuesSourceBased)((Object)parent)).valuesSourceConfig()) != null && config.valid() && (requiredValuesSourceType == null || requiredValuesSourceType.isAssignableFrom(config.valueSourceType()))) {
                return config;
            }
            parent = parent.parent();
        }
        throw new AggregationExecutionException("could not find the appropriate value context to perform aggregation [" + aggName + "]");
    }

    public static abstract class LeafOnly<VS extends ValuesSource>
    extends ValueSourceAggregatorFactory<VS> {
        protected LeafOnly(String name, String type, ValuesSourceConfig<VS> valuesSourceConfig) {
            super(name, type, valuesSourceConfig);
        }

        @Override
        public AggregatorFactory subFactories(AggregatorFactories subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.type + "] cannot accept sub-aggregations");
        }
    }
}

