/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.confluence.v6;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.confluence.v6.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.client.ConfluenceClient;
import org.apache.manifoldcf.crawler.connectors.confluence.v6.model.ConfluenceUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceAuthorityConnector
extends BaseAuthorityConnector {
    private static final String PARAMETER_PREFIX = "confluence_";
    private static final String CONF_SERVER_TAB_PROPERTY = "ConfluenceAuthorityConnector.Server";
    private static final String CONF_CACHE_TAB_PROPERTY = "ConfluenceAuthorityConnector.Cache";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration_conf.js";
    private static final String EDIT_CONFIG_FORWARD_CACHE = "editConfiguration_conf_cache.html";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_conf_server.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration_conf.html";
    private Logger logger = LoggerFactory.getLogger(ConfluenceAuthorityConnector.class);
    protected String protocol = null;
    protected String host = null;
    protected String port = null;
    protected String path = null;
    protected String username = null;
    protected String password = null;
    protected String socketTimeout = null;
    protected String connectionTimeout = null;
    private String cacheLifetime = null;
    private String cacheLRUsize = null;
    private final long responseLifetime = 60000L;
    private final int LRUsize = 1000;
    protected String proxyUsername = null;
    protected String proxyPassword = null;
    protected String proxyProtocol = null;
    protected String proxyHost = null;
    protected String proxyPort = null;
    private ICacheManager cacheManager = null;
    protected ConfluenceClient confluenceClient = null;
    protected static StringSet emptyStringSet = new StringSet();

    public void setCacheManager(ICacheManager cm) {
        this.cacheManager = cm;
    }

    public void setConfluenceClient(ConfluenceClient client) {
        this.confluenceClient = client;
    }

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.cacheManager = null;
    }

    public void disconnect() throws ManifoldCFException {
        if (this.confluenceClient != null) {
            this.confluenceClient = null;
        }
        this.protocol = null;
        this.host = null;
        this.port = null;
        this.path = null;
        this.username = null;
        this.password = null;
        this.socketTimeout = null;
        this.connectionTimeout = null;
        this.cacheLifetime = null;
        this.cacheLRUsize = null;
        this.proxyUsername = null;
        this.proxyPassword = null;
        this.proxyProtocol = null;
        this.proxyHost = null;
        this.proxyPort = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.protocol = this.params.getParameter("protocol");
        this.host = this.params.getParameter("host");
        this.port = this.params.getParameter("port");
        this.path = this.params.getParameter("path");
        this.username = this.params.getParameter("username");
        this.password = this.params.getObfuscatedParameter("password");
        this.socketTimeout = this.params.getParameter("socket_timeout");
        this.connectionTimeout = this.params.getParameter("connection_timeout");
        this.cacheLifetime = this.params.getParameter("cache_lifetime");
        if (this.cacheLifetime == null) {
            this.cacheLifetime = "1";
        }
        this.cacheLRUsize = this.params.getParameter("cache_lru_size");
        if (this.cacheLRUsize == null) {
            this.cacheLRUsize = "1000";
        }
        this.proxyUsername = this.params.getParameter("proxy_username");
        this.proxyPassword = this.params.getObfuscatedParameter("proxy_password");
        this.proxyProtocol = this.params.getParameter("proxy_port");
        this.proxyHost = this.params.getParameter("proxy_host");
        this.proxyPort = this.params.getParameter("proxy_port");
        try {
            this.initConfluenceClient();
        }
        catch (ManifoldCFException e) {
            this.logger.debug("Not possible to initialize Confluence client. Reason: {}", (Object)e.getMessage());
        }
    }

    public String check() throws ManifoldCFException {
        try {
            Boolean result;
            if (!this.isConnected()) {
                this.initConfluenceClient();
            }
            if ((result = Boolean.valueOf(this.confluenceClient.checkAuth())).booleanValue()) {
                return super.check();
            }
            throw new ManifoldCFException("Confluence instance could not be reached");
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
        catch (Exception e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void initConfluenceClient() throws ManifoldCFException {
        if (this.confluenceClient == null) {
            int proxyPortInt;
            int connectionTimeoutInt;
            int socketTimeoutInt;
            int portInt;
            if (StringUtils.isEmpty((String)this.protocol)) {
                throw new ManifoldCFException("Parameter protocol required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence protocol = '" + this.protocol + "'"));
            }
            if (StringUtils.isEmpty((String)this.host)) {
                throw new ManifoldCFException("Parameter host required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence host = '" + this.host + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence port = '" + this.port + "'"));
            }
            if (StringUtils.isEmpty((String)this.path)) {
                throw new ManifoldCFException("Parameter path required but not set");
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence path = '" + this.path + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence username = '" + this.username + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence password '" + this.password != null ? "set" : "not set'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence socket timeout = '" + this.socketTimeout + "'"));
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Confluence connection timeout = '" + this.connectionTimeout + "'"));
            }
            if (this.port != null && this.port.length() > 0) {
                try {
                    portInt = Integer.parseInt(this.port);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                portInt = this.protocol.toLowerCase(Locale.ROOT).equals("http") ? 80 : 443;
            }
            if (this.socketTimeout != null && this.socketTimeout.length() > 0) {
                try {
                    socketTimeoutInt = Integer.parseInt(this.socketTimeout);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                socketTimeoutInt = 900000;
            }
            if (this.connectionTimeout != null && this.connectionTimeout.length() > 0) {
                try {
                    connectionTimeoutInt = Integer.parseInt(this.connectionTimeout);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                connectionTimeoutInt = 60000;
            }
            if (this.proxyPort != null && this.proxyPort.length() > 0) {
                try {
                    proxyPortInt = Integer.parseInt(this.proxyPort);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                proxyPortInt = -1;
            }
            this.confluenceClient = new ConfluenceClient(this.protocol, this.host, portInt, this.path, this.username, this.password, socketTimeoutInt, connectionTimeoutInt, this.proxyUsername, this.proxyPassword, this.proxyProtocol, this.proxyHost, proxyPortInt);
        }
    }

    public boolean isConnected() {
        return this.confluenceClient != null;
    }

    private void fillInCacheTab(Map<String, String> velocityContext, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String cacheLifetime = parameters.getParameter("cache_lifetime");
        if (cacheLifetime == null) {
            cacheLifetime = "1";
        }
        velocityContext.put("CACHE_LIFETIME", cacheLifetime);
        String cacheLRUsize = parameters.getParameter("cache_lru_size");
        if (cacheLRUsize == null) {
            cacheLRUsize = "1000";
        }
        velocityContext.put("CACHE_LRU_SIZE", cacheLRUsize);
    }

    private void fillInServerConfigurationMap(Map<String, String> serverMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String confluenceProtocol = parameters.getParameter("protocol");
        String confluenceHost = parameters.getParameter("host");
        String confluencePort = parameters.getParameter("port");
        String confluencePath = parameters.getParameter("path");
        String confluenceUsername = parameters.getParameter("username");
        String confluencePassword = parameters.getObfuscatedParameter("password");
        String confluenceSocketTimeout = parameters.getParameter("socket_timeout");
        String confluenceConnectionTimeout = parameters.getParameter("connection_timeout");
        String confluenceProxyUsername = parameters.getParameter("proxy_username");
        String confluenceProxyPassword = parameters.getObfuscatedParameter("proxy_password");
        String confluenceProxyProtocol = parameters.getParameter("proxy_protocol");
        String confluenceProxyHost = parameters.getParameter("proxy_host");
        String confluenceProxyPort = parameters.getParameter("proxy_port");
        if (confluenceProtocol == null) {
            confluenceProtocol = "http";
        }
        if (confluenceHost == null) {
            confluenceHost = "";
        }
        if (confluencePort == null) {
            confluencePort = "8090";
        }
        if (confluencePath == null) {
            confluencePath = "/confluence";
        }
        if (confluenceUsername == null) {
            confluenceUsername = "";
        }
        confluencePassword = confluencePassword == null ? "" : mapper.mapPasswordToKey(confluencePassword);
        if (confluenceSocketTimeout == null) {
            confluenceSocketTimeout = "900000";
        }
        if (confluenceConnectionTimeout == null) {
            confluenceConnectionTimeout = "60000";
        }
        if (confluenceProxyUsername == null) {
            confluenceProxyUsername = "";
        }
        confluenceProxyPassword = confluenceProxyPassword == null ? "" : mapper.mapPasswordToKey(confluenceProxyPassword);
        if (confluenceProxyProtocol == null) {
            confluenceProxyProtocol = "http";
        }
        if (confluenceProxyHost == null) {
            confluenceProxyHost = "";
        }
        if (confluenceProxyPort == null) {
            confluenceProxyPort = "";
        }
        serverMap.put("confluence_protocol", confluenceProtocol);
        serverMap.put("confluence_host", confluenceHost);
        serverMap.put("confluence_port", confluencePort);
        serverMap.put("confluence_path", confluencePath);
        serverMap.put("confluence_username", confluenceUsername);
        serverMap.put("confluence_password", confluencePassword);
        serverMap.put("confluence_socket_timeout", confluenceSocketTimeout);
        serverMap.put("confluence_connection_timeout", confluenceConnectionTimeout);
        serverMap.put("confluence_proxy_username", confluenceProxyUsername);
        serverMap.put("confluence_proxy_password", confluenceProxyPassword);
        serverMap.put("confluence_proxy_protocol", confluenceProxyProtocol);
        serverMap.put("confluence_proxy_host", confluenceProxyHost);
        serverMap.put("confluence_proxy_port", confluenceProxyPort);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        this.fillInCacheTab(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap, true);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, CONF_SERVER_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, CONF_CACHE_TAB_PROPERTY));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        this.fillInCacheTab(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap, true);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TabName", tabName);
        this.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        this.fillInCacheTab(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap, true);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_CACHE, paramMap, true);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String confluenceProxyPassword;
        String confluenceProxyUsername;
        String confluenceProxyPort;
        String confluenceProxyHost;
        String confluenceProxyProtocol;
        String confluenceConnectionTimeout;
        String confluenceSocketTimeout;
        String confluencePassword;
        String confluenceUsername;
        String confluencePath;
        String confluencePort;
        String confluenceHost;
        String confluenceProtocol;
        String cacheLRUsize;
        String cacheLifetime = variableContext.getParameter("cache_lifetime");
        if (cacheLifetime != null) {
            parameters.setParameter("cache_lifetime", cacheLifetime);
        }
        if ((cacheLRUsize = variableContext.getParameter("cache_lru_size")) != null) {
            parameters.setParameter("cache_lru_size", cacheLRUsize);
        }
        if ((confluenceProtocol = variableContext.getParameter("confluence_protocol")) != null) {
            parameters.setParameter("protocol", confluenceProtocol);
        }
        if ((confluenceHost = variableContext.getParameter("confluence_host")) != null) {
            parameters.setParameter("host", confluenceHost);
        }
        if ((confluencePort = variableContext.getParameter("confluence_port")) != null) {
            parameters.setParameter("port", confluencePort);
        }
        if ((confluencePath = variableContext.getParameter("confluence_path")) != null) {
            parameters.setParameter("path", confluencePath);
        }
        if ((confluenceUsername = variableContext.getParameter("confluence_username")) != null) {
            parameters.setParameter("username", confluenceUsername);
        }
        if ((confluencePassword = variableContext.getParameter("confluence_password")) != null) {
            parameters.setObfuscatedParameter("password", variableContext.mapKeyToPassword(confluencePassword));
        }
        if ((confluenceSocketTimeout = variableContext.getParameter("confluence_socket_timeout")) != null) {
            parameters.setParameter("socket_timeout", confluenceSocketTimeout);
        }
        if ((confluenceConnectionTimeout = variableContext.getParameter("confluence_connection_timeout")) != null) {
            parameters.setParameter("connection_timeout", confluenceConnectionTimeout);
        }
        if ((confluenceProxyProtocol = variableContext.getParameter("confluence_proxy_protocol")) != null) {
            parameters.setParameter("proxy_protocol", confluenceProxyProtocol);
        }
        if ((confluenceProxyHost = variableContext.getParameter("confluence_proxy_host")) != null) {
            parameters.setParameter("proxy_host", confluenceProxyHost);
        }
        if ((confluenceProxyPort = variableContext.getParameter("confluence_proxy_port")) != null) {
            parameters.setParameter("proxy_port", confluenceProxyPort);
        }
        if ((confluenceProxyUsername = variableContext.getParameter("confluence_proxy_username")) != null) {
            parameters.setParameter("proxy_username", confluenceProxyUsername);
        }
        if ((confluenceProxyPassword = variableContext.getParameter("confluence_proxy_password")) != null) {
            parameters.setObfuscatedParameter("proxy_password", variableContext.mapKeyToPassword(confluenceProxyPassword));
        }
        return null;
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        String finalUsername = userName;
        if (finalUsername.indexOf("@") != -1) {
            finalUsername = finalUsername.substring(0, finalUsername.indexOf("@"));
        }
        if (Logging.authorityConnectors != null && Logging.authorityConnectors.isDebugEnabled()) {
            Logging.authorityConnectors.debug((Object)("Get Confluence autorizations for user '" + finalUsername + "'"));
        }
        if (this.cacheManager != null) {
            AuthorizationResponseDescription objectDescription = new AuthorizationResponseDescription(finalUsername, this.responseLifetime, this.LRUsize);
            ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
            try {
                AuthorizationResponse response;
                ICacheCreateHandle createHandle;
                block12: {
                    AuthorizationResponse authorizationResponse;
                    createHandle = this.cacheManager.enterCreateSection(ch);
                    try {
                        response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                        if (response == null) break block12;
                        if (Logging.authorityConnectors != null && Logging.authorityConnectors.isDebugEnabled()) {
                            Logging.authorityConnectors.debug((Object)("Found cached Confluence autorizations for user '" + finalUsername + "'"));
                        }
                        authorizationResponse = response;
                    }
                    catch (Throwable throwable) {
                        this.cacheManager.leaveCreateSection(createHandle);
                        throw throwable;
                    }
                    this.cacheManager.leaveCreateSection(createHandle);
                    return authorizationResponse;
                }
                response = this.getAuthorizationResponseUncached(finalUsername);
                this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
                AuthorizationResponse authorizationResponse = response;
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            finally {
                this.cacheManager.leaveCache(ch);
            }
        }
        return this.getAuthorizationResponseUncached(finalUsername);
    }

    private AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        if (Logging.authorityConnectors != null && Logging.authorityConnectors.isDebugEnabled()) {
            Logging.authorityConnectors.debug((Object)("Get uncached Confluence autorizations for user '" + userName + "'"));
        }
        try {
            ConfluenceUser confluenceUser = this.confluenceClient.getUserAuthorities(userName);
            if (confluenceUser.getUsername() == null || confluenceUser.getUsername().isEmpty() || confluenceUser.getAuthorities().isEmpty()) {
                if (Logging.authorityConnectors != null && Logging.authorityConnectors.isDebugEnabled()) {
                    Logging.authorityConnectors.debug((Object)("No Confluence user found for user '" + userName + "'"));
                }
                return RESPONSE_USERNOTFOUND;
            }
            if (Logging.authorityConnectors != null && Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Found Confluence corresponding user for user '" + userName + "'"));
            }
            return new AuthorizationResponse(confluenceUser.getAuthorities().toArray(new String[confluenceUser.getAuthorities().size()]), 0);
        }
        catch (Exception e) {
            return RESPONSE_UNREACHABLE;
        }
    }

    protected static class AuthorizationResponseDescription
    extends BaseDescription {
        protected String userName;
        protected long responseLifetime;
        protected long expirationTime = -1L;

        public AuthorizationResponseDescription(String userName, long responseLifetime, int LRUsize) {
            super("SharePointADAuthority", LRUsize);
            this.userName = userName;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
            sb.append("-").append(this.userName);
            return sb.toString();
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            int rval = this.userName.hashCode();
            return rval;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationResponseDescription)) {
                return false;
            }
            AuthorizationResponseDescription ard = (AuthorizationResponseDescription)((Object)o);
            return ard.userName.equals(this.userName);
        }
    }
}

