/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.List;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.CoordinateOperationRegistry;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class SubOperationInfo {
    private static final Class<?>[][] COMPATIBLE_TYPES = new Class[][]{{GeodeticCRS.class}, {VerticalCRS.class, GeodeticCRS.class}, {TemporalCRS.class}, {DefaultParametricCRS.class}, {EngineeringCRS.class}, {ImageCRS.class}};
    final CoordinateOperation operation;
    private final double[] constants;
    private final int startAtDimension;
    private final int endAtDimension;
    final int targetComponentIndex;

    private static Class<?> type(SingleCRS singleCRS) {
        while (singleCRS instanceof GeneralDerivedCRS) {
            singleCRS = (SingleCRS)((GeneralDerivedCRS)singleCRS).getBaseCRS();
        }
        return singleCRS.getClass();
    }

    private SubOperationInfo(int n, CoordinateOperation coordinateOperation, double[] dArray, int n2, int n3) {
        this.operation = coordinateOperation;
        this.constants = dArray;
        this.startAtDimension = n2;
        this.endAtDimension = n3;
        this.targetComponentIndex = n;
        assert (coordinateOperation == null != (dArray == null));
    }

    static SubOperationInfo[] createSteps(CoordinateOperationFinder coordinateOperationFinder, List<? extends SingleCRS> list, List<? extends SingleCRS> list2) throws FactoryException, TransformException {
        SubOperationInfo[] subOperationInfoArray = new SubOperationInfo[list2.size()];
        boolean[] blArray = new boolean[list.size()];
        int n = 0;
        block2: for (int i = 0; i < subOperationInfoArray.length; ++i) {
            SingleCRS singleCRS = list2.get(i);
            int n2 = n;
            n += singleCRS.getCoordinateSystem().getDimension();
            Class<?> clazz = SubOperationInfo.type(singleCRS);
            OperationNotFoundException operationNotFoundException = null;
            int n3 = 0;
            for (int j = 0; j < blArray.length; ++j) {
                SingleCRS singleCRS2 = list.get(j);
                int n4 = n3;
                n3 += singleCRS2.getCoordinateSystem().getDimension();
                if (blArray[j]) continue;
                for (Class<?>[] classArray : COMPATIBLE_TYPES) {
                    if (!classArray[0].isAssignableFrom(clazz)) continue;
                    for (Class<?> clazz2 : classArray) {
                        CoordinateOperation coordinateOperation;
                        if (!clazz2.isAssignableFrom(SubOperationInfo.type(singleCRS2))) continue;
                        try {
                            coordinateOperation = coordinateOperationFinder.createOperation((CoordinateReferenceSystem)singleCRS2, (CoordinateReferenceSystem)singleCRS);
                        }
                        catch (OperationNotFoundException operationNotFoundException2) {
                            if (operationNotFoundException == null) {
                                operationNotFoundException = operationNotFoundException2;
                                continue;
                            }
                            operationNotFoundException.addSuppressed((Throwable)operationNotFoundException2);
                            continue;
                        }
                        blArray[j] = true;
                        subOperationInfoArray[i] = new SubOperationInfo(i, coordinateOperation, null, n4, n3);
                        if (operationNotFoundException == null) continue block2;
                        CoordinateOperationRegistry.recoverableException("decompose", (Exception)((Object)operationNotFoundException));
                        continue block2;
                    }
                }
            }
            if (operationNotFoundException != null) {
                throw operationNotFoundException;
            }
            double[] dArray = CoordinateOperationContext.getConstantCoordinates();
            if (dArray == null || dArray.length < n) {
                return null;
            }
            for (int j = n2; j < n; ++j) {
                if (!Double.isNaN(dArray[j])) continue;
                return null;
            }
            subOperationInfoArray[i] = new SubOperationInfo(i, null, dArray, n2, n);
        }
        return subOperationInfoArray;
    }

    static CoordinateReferenceSystem[] getSourceCRS(SubOperationInfo[] subOperationInfoArray) {
        int n = subOperationInfoArray.length;
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            SubOperationInfo subOperationInfo = subOperationInfoArray[i];
            if (subOperationInfo.operation != null) continue;
            System.arraycopy(subOperationInfoArray, i + 1, subOperationInfoArray, i, n2 - i);
            subOperationInfoArray[n2] = subOperationInfo;
            --n;
        }
        CoordinateReferenceSystem[] coordinateReferenceSystemArray = new CoordinateReferenceSystem[n];
        for (int i = 0; i < n; ++i) {
            coordinateReferenceSystemArray[i] = subOperationInfoArray[i].operation.getSourceCRS();
        }
        return coordinateReferenceSystemArray;
    }

    static int indexOfFinal(SubOperationInfo[] subOperationInfoArray) {
        int n = subOperationInfoArray.length;
        while (n != 0 && subOperationInfoArray[--n].isIdentity()) {
        }
        return n;
    }

    static MatrixSIS sourceToSelected(int n, SubOperationInfo[] subOperationInfoArray) {
        int n2 = 0;
        for (SubOperationInfo subOperationInfo : subOperationInfoArray) {
            if (subOperationInfo.operation == null) break;
            n2 += subOperationInfo.endAtDimension - subOperationInfo.startAtDimension;
        }
        MatrixSIS matrixSIS = Matrices.createZero(n2 + 1, n + 1);
        matrixSIS.setElement(n2, n, 1.0);
        int n3 = 0;
        for (SubOperationInfo subOperationInfo : subOperationInfoArray) {
            for (int i = subOperationInfo.startAtDimension; i < subOperationInfo.endAtDimension; ++i) {
                matrixSIS.setElement(n3++, i, 1.0);
            }
        }
        return matrixSIS;
    }

    final boolean isIdentity() {
        return this.operation != null && this.operation.getMathTransform().isIdentity();
    }

    static MatrixSIS createConstantOperation(SubOperationInfo[] subOperationInfoArray, int n, int n2, int n3) {
        int n4;
        boolean[] blArray = new boolean[n3];
        MatrixSIS matrixSIS = Matrices.createZero(n3 + 1, n2 + 1);
        matrixSIS.setElement(n3, n2, 1.0);
        do {
            SubOperationInfo subOperationInfo = subOperationInfoArray[n];
            for (n4 = subOperationInfo.startAtDimension; n4 < subOperationInfo.endAtDimension; ++n4) {
                matrixSIS.setElement(n4, n2, subOperationInfo.constants[n4]);
                blArray[n4] = true;
            }
        } while (++n < subOperationInfoArray.length);
        int n5 = 0;
        for (n4 = 0; n4 < n3; ++n4) {
            if (blArray[n4]) continue;
            matrixSIS.setElement(n4, n5++, 1.0);
        }
        return matrixSIS;
    }
}

