/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import org.h2.util.New;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseWatcher
extends PhantomReference<Object> {
    public static ReferenceQueue<Object> queue = new ReferenceQueue();
    public static HashSet<CloseWatcher> refs = New.hashSet();
    private String openStackTrace;
    private Closeable closeable;

    public CloseWatcher(Object object, ReferenceQueue<Object> referenceQueue, Closeable closeable) {
        super(object, referenceQueue);
        this.closeable = closeable;
    }

    public static CloseWatcher pollUnclosed() {
        CloseWatcher closeWatcher;
        ReferenceQueue<Object> referenceQueue = queue;
        if (referenceQueue == null) {
            return null;
        }
        do {
            if ((closeWatcher = (CloseWatcher)referenceQueue.poll()) == null) {
                return null;
            }
            if (refs == null) continue;
            refs.remove(closeWatcher);
        } while (closeWatcher.closeable == null);
        return closeWatcher;
    }

    public static CloseWatcher register(Object object, Closeable closeable, boolean bl) {
        ReferenceQueue<Object> referenceQueue = queue;
        if (referenceQueue == null) {
            queue = referenceQueue = new ReferenceQueue();
        }
        CloseWatcher closeWatcher = new CloseWatcher(object, referenceQueue, closeable);
        if (bl) {
            Exception exception = new Exception("Open Stack Trace");
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            closeWatcher.openStackTrace = stringWriter.toString();
        }
        if (refs == null) {
            refs = New.hashSet();
        }
        refs.add(closeWatcher);
        return closeWatcher;
    }

    public static void unregister(CloseWatcher closeWatcher) {
        closeWatcher.closeable = null;
        refs.remove(closeWatcher);
    }

    public String getOpenStackTrace() {
        return this.openStackTrace;
    }

    public Closeable getCloseable() {
        return this.closeable;
    }
}

