/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.media;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.mov.QuickTimeContext;
import com.drew.metadata.mov.QuickTimeMediaHandler;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.atoms.SoundInformationMediaHeaderAtom;
import com.drew.metadata.mov.atoms.SoundSampleDescriptionAtom;
import com.drew.metadata.mov.media.QuickTimeSoundDirectory;
import java.io.IOException;

public class QuickTimeSoundHandler
extends QuickTimeMediaHandler<QuickTimeSoundDirectory> {
    public QuickTimeSoundHandler(Metadata metadata, QuickTimeContext context) {
        super(metadata, context);
    }

    @Override
    @NotNull
    protected QuickTimeSoundDirectory getDirectory() {
        return new QuickTimeSoundDirectory();
    }

    @Override
    protected String getMediaInformation() {
        return "smhd";
    }

    @Override
    public void processSampleDescription(@NotNull SequentialReader reader, @NotNull Atom atom) throws IOException {
        SoundSampleDescriptionAtom soundSampleDescriptionAtom = new SoundSampleDescriptionAtom(reader, atom);
        soundSampleDescriptionAtom.addMetadata((QuickTimeSoundDirectory)this.directory);
    }

    @Override
    public void processMediaInformation(@NotNull SequentialReader reader, @NotNull Atom atom) throws IOException {
        SoundInformationMediaHeaderAtom soundInformationMediaHeaderAtom = new SoundInformationMediaHeaderAtom(reader, atom);
        soundInformationMediaHeaderAtom.addMetadata((QuickTimeSoundDirectory)this.directory);
    }

    @Override
    protected void processTimeToSample(@NotNull SequentialReader reader, @NotNull Atom atom, QuickTimeContext context) throws IOException {
        ((QuickTimeSoundDirectory)this.directory).setDouble(772, context.timeScale.longValue());
    }
}

