/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.cli.CoreExtensions;
import org.apache.maven.api.cli.extensions.CoreExtension;
import org.apache.maven.api.cli.extensions.InputLocation;
import org.apache.maven.cling.invoker.CoreExtensionSelector;
import org.apache.maven.cling.invoker.LookupContext;
import org.apache.maven.cling.invoker.LookupInvoker;

public class PrecedenceCoreExtensionSelector<C extends LookupContext>
implements CoreExtensionSelector<C> {
    @Override
    public List<CoreExtension> selectCoreExtensions(LookupInvoker<C> invoker, C context) {
        Optional coreExtensions = ((LookupContext)context).invokerRequest.coreExtensions();
        if (coreExtensions.isEmpty() || ((List)coreExtensions.get()).isEmpty()) {
            return List.of();
        }
        return this.selectCoreExtensions(context, (List)((LookupContext)context).invokerRequest.coreExtensions().orElseThrow());
    }

    protected List<CoreExtension> selectCoreExtensions(C context, List<CoreExtensions> configuredCoreExtensions) {
        ((LookupContext)context).logger.debug("Configured core extensions (in precedence order):");
        for (CoreExtensions source : configuredCoreExtensions) {
            ((LookupContext)context).logger.debug("* Source file: " + String.valueOf(source.source()));
            for (CoreExtension extension : source.coreExtensions()) {
                ((LookupContext)context).logger.debug("  - " + extension.getId() + " -> " + this.formatLocation(extension.getLocation((Object)"")));
            }
        }
        LinkedHashMap<CallSite, CoreExtension> selectedExtensions = new LinkedHashMap<CallSite, CoreExtension>();
        ArrayList<String> conflicts = new ArrayList<String>();
        for (CoreExtensions coreExtensions : configuredCoreExtensions) {
            for (CoreExtension coreExtension : coreExtensions.coreExtensions()) {
                String key = coreExtension.getGroupId() + ":" + coreExtension.getArtifactId();
                CoreExtension conflict = selectedExtensions.putIfAbsent((CallSite)((Object)key), coreExtension);
                if (conflict == null || Objects.equals(coreExtension.getVersion(), conflict.getVersion())) continue;
                conflicts.add(String.format("Conflicting extension %s: %s vs %s", key, this.formatLocation(conflict.getLocation((Object)"")), this.formatLocation(coreExtension.getLocation((Object)""))));
            }
        }
        if (!conflicts.isEmpty()) {
            ((LookupContext)context).logger.warn("Found " + conflicts.size() + " extension conflict(s):");
            for (String conflict : conflicts) {
                ((LookupContext)context).logger.warn("* " + conflict);
            }
            ((LookupContext)context).logger.warn("");
            ((LookupContext)context).logger.warn("Order of core extensions precedence is project > user > installation. Selected extensions are:");
            for (CoreExtension extension : selectedExtensions.values()) {
                ((LookupContext)context).logger.warn("* " + extension.getId() + " configured in " + this.formatLocation(extension.getLocation((Object)"")));
            }
        }
        ((LookupContext)context).logger.debug("Selected core extensions (in loading order):");
        for (CoreExtension source : selectedExtensions.values()) {
            ((LookupContext)context).logger.debug("* " + source.getId() + ": " + this.formatLocation(source.getLocation((Object)"")));
        }
        return List.copyOf(selectedExtensions.values());
    }

    protected String formatLocation(InputLocation location) {
        return location.getSource().getLocation() + ":" + location.getLineNumber();
    }
}

