/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.api.Lifecycle;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginExecution;
import org.apache.maven.internal.impl.DefaultLifecycleRegistry;

public class Lifecycles {
    static Lifecycle.Phase phase(String name) {
        return new DefaultPhase(name, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    static Lifecycle.Phase phase(String name, Lifecycle.Phase ... phases) {
        return new DefaultPhase(name, Collections.emptyList(), Collections.emptyList(), Arrays.asList(phases));
    }

    static Lifecycle.Phase phase(String name, Lifecycle.Link link, Lifecycle.Phase ... phases) {
        return new DefaultPhase(name, Collections.emptyList(), Collections.singletonList(link), Arrays.asList(phases));
    }

    static Lifecycle.Phase phase(String name, Plugin plugin) {
        return new DefaultPhase(name, Collections.singletonList(plugin), Collections.emptyList(), Collections.emptyList());
    }

    static Lifecycle.Phase phase(String name, Lifecycle.Link link, Plugin plugin) {
        return new DefaultPhase(name, Collections.singletonList(plugin), Collections.singletonList(link), Collections.emptyList());
    }

    static Lifecycle.Phase phase(String name, Lifecycle.Link link1, Lifecycle.Link link2, Lifecycle.Phase ... phases) {
        return new DefaultPhase(name, Collections.emptyList(), Arrays.asList(link1, link2), Arrays.asList(phases));
    }

    static Lifecycle.Phase phase(String name, Lifecycle.Link link1, Lifecycle.Link link2, Lifecycle.Link link3, Lifecycle.Phase ... phases) {
        return new DefaultPhase(name, Collections.emptyList(), Arrays.asList(link1, link2, link3), Arrays.asList(phases));
    }

    static Lifecycle.Phase phase(String name, Collection<Lifecycle.Link> links, Lifecycle.Phase ... phases) {
        return new DefaultPhase(name, Collections.emptyList(), links, Arrays.asList(phases));
    }

    static Plugin plugin(String coords, String phase) {
        String[] c = coords.split(":");
        return Plugin.newBuilder().groupId(c[0]).artifactId(c[1]).version(c[2]).executions(Collections.singletonList(PluginExecution.newBuilder().id("default-" + c[3]).phase(phase).goals(Collections.singletonList(c[3])).location((Object)"", DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_INPUT_LOCATION).location((Object)"id", DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_INPUT_LOCATION).location((Object)"phase", DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_INPUT_LOCATION).location((Object)"goals", DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_INPUT_LOCATION).build())).location((Object)"", DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_INPUT_LOCATION).location((Object)"groupId", DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_INPUT_LOCATION).location((Object)"artifactId", DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_INPUT_LOCATION).location((Object)"version", DefaultLifecycleRegistry.DEFAULT_LIFECYCLE_INPUT_LOCATION).build();
    }

    static Lifecycle.Link after(final String b) {
        return new Lifecycle.Link(){

            public Lifecycle.Link.Kind kind() {
                return Lifecycle.Link.Kind.AFTER;
            }

            public Lifecycle.Pointer pointer() {
                return new Lifecycle.PhasePointer(){

                    public String phase() {
                        return b;
                    }
                };
            }
        };
    }

    static Lifecycle.Link dependencies(final String scope, final String phase) {
        return new Lifecycle.Link(){

            public Lifecycle.Link.Kind kind() {
                return Lifecycle.Link.Kind.AFTER;
            }

            public Lifecycle.Pointer pointer() {
                return new Lifecycle.DependenciesPointer(){

                    public String phase() {
                        return phase;
                    }

                    public String scope() {
                        return scope;
                    }
                };
            }
        };
    }

    static Lifecycle.Alias alias(String v3Phase, String v4Phase) {
        return new DefaultAlias(v3Phase, v4Phase);
    }

    static class DefaultPhase
    implements Lifecycle.Phase {
        private final String name;
        private final List<Plugin> plugins;
        private final Collection<Lifecycle.Link> links;
        private final List<Lifecycle.Phase> phases;

        DefaultPhase(String name, List<Plugin> plugins, Collection<Lifecycle.Link> links, List<Lifecycle.Phase> phases) {
            this.name = name;
            this.plugins = plugins;
            this.links = links;
            this.phases = phases;
        }

        public String name() {
            return this.name;
        }

        public List<Plugin> plugins() {
            return this.plugins;
        }

        public Collection<Lifecycle.Link> links() {
            return this.links;
        }

        public List<Lifecycle.Phase> phases() {
            return this.phases;
        }

        public Stream<Lifecycle.Phase> allPhases() {
            return Stream.concat(Stream.of(this), this.phases().stream().flatMap(Lifecycle.Phase::allPhases));
        }
    }

    static class DefaultAlias
    implements Lifecycle.Alias {
        private final String v3Phase;
        private final String v4Phase;

        DefaultAlias(String v3Phase, String v4Phase) {
            this.v3Phase = v3Phase;
            this.v4Phase = v4Phase;
        }

        public String v3Phase() {
            return this.v3Phase;
        }

        public String v4Phase() {
            return this.v4Phase;
        }
    }
}

