/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.future;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import org.apache.sshd.common.future.CancelFuture;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.VerifiableFuture;

public class DefaultCancelFuture
extends DefaultSshFuture<CancelFuture>
implements CancelFuture,
VerifiableFuture<Boolean> {
    private CancellationException backTrace;

    protected DefaultCancelFuture(Object id) {
        super(id, null);
    }

    @Override
    public Boolean verify(long timeoutMillis, CancelOption ... options) throws IOException {
        return this.verifyResult(Boolean.class, timeoutMillis, options);
    }

    @Override
    public void setCanceled() {
        this.setCanceled(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanceled(Throwable error) {
        DefaultCancelFuture defaultCancelFuture = this;
        synchronized (defaultCancelFuture) {
            if (this.backTrace == null) {
                this.backTrace = new CancellationException("Canceled by framework");
            }
            if (error != null) {
                this.backTrace.addSuppressed(error);
            }
        }
        this.setValue(Boolean.TRUE);
    }

    @Override
    public void setNotCanceled() {
        this.setValue(Boolean.FALSE);
    }

    @Override
    public boolean isCanceled() {
        return Boolean.TRUE.equals(this.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackTrace(CancellationException backTrace) {
        DefaultCancelFuture defaultCancelFuture = this;
        synchronized (defaultCancelFuture) {
            if (this.backTrace == null) {
                this.backTrace = Objects.requireNonNull(backTrace, "Cancellation backtrace must not be null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancellationException getBackTrace() {
        DefaultCancelFuture defaultCancelFuture = this;
        synchronized (defaultCancelFuture) {
            return this.backTrace;
        }
    }
}

