/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.scp.common.helpers;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.scp.ScpModuleProperties;
import org.apache.sshd.scp.common.ScpException;
import org.apache.sshd.scp.common.helpers.AbstractScpCommandDetails;
import org.apache.sshd.scp.common.helpers.CommandStatusHandler;
import org.apache.sshd.scp.common.helpers.ScpAckInfo;
import org.slf4j.Logger;

public final class ScpIoUtils {
    public static final Set<ClientChannelEvent> COMMAND_WAIT_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.EXIT_STATUS, ClientChannelEvent.CLOSED));

    private ScpIoUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static String readLine(InputStream in, Charset cs) throws IOException {
        return ScpIoUtils.readLine(in, cs, false);
    }

    public static String readLine(InputStream in, Charset cs, boolean canEof) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(127);){
            while (true) {
                int c;
                if ((c = in.read()) == 10) {
                    String string = baos.toString(cs.name());
                    return string;
                }
                if (c == -1) {
                    if (!canEof) {
                        throw new EOFException("EOF while await end of line");
                    }
                    String string = null;
                    return string;
                }
                baos.write(c);
            }
        }
    }

    public static void writeLine(OutputStream out, Charset cs, String cmd) throws IOException {
        if (cmd != null) {
            out.write(cmd.getBytes(cs));
        }
        out.write(10);
        out.flush();
    }

    public static ScpAckInfo sendAcknowledgedCommand(AbstractScpCommandDetails cmd, InputStream in, Charset csIn, OutputStream out, Charset csOut) throws IOException {
        return ScpIoUtils.sendAcknowledgedCommand(cmd.toHeader(), in, csIn, out, csOut);
    }

    public static ScpAckInfo sendAcknowledgedCommand(String cmd, InputStream in, Charset csIn, OutputStream out, Charset csOut) throws IOException {
        ScpIoUtils.writeLine(out, csOut, cmd);
        return ScpAckInfo.readAck(in, csIn, false);
    }

    public static String getExitStatusName(Integer exitStatus) {
        if (exitStatus == null) {
            return "null";
        }
        switch (exitStatus) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "WARNING";
            }
            case 2: {
                return "ERROR";
            }
        }
        return exitStatus.toString();
    }

    public static ChannelExec openCommandChannel(ClientSession session, String cmd, Logger log) throws IOException {
        Duration waitTimeout = (Duration)ScpModuleProperties.SCP_EXEC_CHANNEL_OPEN_TIMEOUT.getRequired((PropertyResolver)session);
        ChannelExec channel = session.createExecChannel(cmd);
        long startTime = System.nanoTime();
        try {
            channel.open().verify(waitTimeout);
            long endTime = System.nanoTime();
            long nanosWait = endTime - startTime;
            if (log != null && log.isTraceEnabled()) {
                log.trace("openCommandChannel({})[{}] completed after {} nanos out of {}", new Object[]{session, cmd, nanosWait, waitTimeout.toNanos()});
            }
            return channel;
        }
        catch (IOException | RuntimeException e) {
            long endTime = System.nanoTime();
            long nanosWait = endTime - startTime;
            if (log != null && log.isTraceEnabled()) {
                log.trace("openCommandChannel({})[{}] failed after {} nanos out of {}: {}", new Object[]{session, cmd, nanosWait, waitTimeout.toNanos(), e.toString()});
            }
            channel.close(false);
            throw e;
        }
    }

    public static void handleCommandExitStatus(ClientSession session, String cmd, ClientChannel channel, CommandStatusHandler handler, Logger log) throws IOException {
        Duration timeout = (Duration)ScpModuleProperties.SCP_EXEC_CHANNEL_EXIT_STATUS_TIMEOUT.getRequired((PropertyResolver)channel);
        if (GenericUtils.isNegativeOrNull((Duration)timeout)) {
            if (handler == null) {
                ScpIoUtils.handleCommandExitStatus(session, cmd, null, log);
            } else {
                handler.handleCommandExitStatus(session, cmd, null);
            }
            return;
        }
        long waitStart = System.nanoTime();
        Set events = channel.waitFor(COMMAND_WAIT_EVENTS, timeout);
        long waitEnd = System.nanoTime();
        if (log != null && log.isDebugEnabled()) {
            log.debug("handleCommandExitStatus({}) cmd='{}', waited={} nanos, events={}", new Object[]{session, cmd, waitEnd - waitStart, events});
        }
        Integer exitStatus = channel.getExitStatus();
        if (handler == null) {
            ScpIoUtils.handleCommandExitStatus(session, cmd, exitStatus, log);
        } else {
            handler.handleCommandExitStatus(session, cmd, exitStatus);
        }
    }

    public static void handleCommandExitStatus(ClientSession session, String cmd, Integer exitStatus, Logger log) throws IOException {
        if (log != null && log.isDebugEnabled()) {
            log.debug("handleCommandExitStatus({}) cmd='{}', exit-status={}", new Object[]{session, cmd, ScpIoUtils.getExitStatusName(exitStatus)});
        }
        if (exitStatus == null) {
            return;
        }
        int statusCode = exitStatus;
        switch (statusCode) {
            case 0: {
                break;
            }
            case 1: {
                if (log == null) break;
                log.warn("handleCommandExitStatus({}) cmd='{}' may have terminated with some problems", (Object)session, (Object)cmd);
                break;
            }
            default: {
                throw new ScpException("Failed to run command='" + cmd + "': " + ScpIoUtils.getExitStatusName(exitStatus), exitStatus);
            }
        }
    }
}

