/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.util.regex.Pattern;
import org.springframework.integration.file.filters.AbstractDirectoryAwareFileListFilter;
import org.springframework.util.Assert;

public abstract class AbstractRegexPatternFileListFilter<F>
extends AbstractDirectoryAwareFileListFilter<F> {
    private Pattern pattern;

    public AbstractRegexPatternFileListFilter(String pattern) {
        this(Pattern.compile(pattern));
    }

    public AbstractRegexPatternFileListFilter(Pattern pattern) {
        Assert.notNull((Object)pattern, (String)"'pattern' must not be null!");
        this.pattern = pattern;
    }

    public void setPattern(String pattern) {
        Assert.notNull((Object)pattern, (String)"'pattern' must not be null!");
        this.setPattern(Pattern.compile(pattern));
    }

    public void setPattern(Pattern pattern) {
        Assert.notNull((Object)pattern, (String)"'pattern' must not be null!");
        this.pattern = pattern;
    }

    @Override
    public boolean accept(F file) {
        return this.alwaysAccept(file) || file != null && this.pattern.matcher(this.getFilename(file)).matches();
    }

    protected abstract String getFilename(F var1);
}

