/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class UIViewRoot
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "j_id";
    private static final int ANY_PHASE_ORDINAL = PhaseId.ANY_PHASE.getOrdinal();
    private final Logger logger = Logger.getLogger(UIViewRoot.class.getName());
    private long _uniqueIdCounter = 0L;
    private Locale _locale;
    private String _renderKitId;
    private String _viewId;
    private List<FacesEvent> _events;
    private List<PhaseListener> _phaseListeners;
    private MethodExpression _beforePhaseListener;
    private MethodExpression _afterPhaseListener;
    private transient Lifecycle _lifecycle = null;

    public UIViewRoot() {
        this.setRendererType(null);
    }

    public void queueEvent(FacesEvent event) {
        this.checkNull(event, "event");
        if (this._events == null) {
            this._events = new ArrayList<FacesEvent>();
        }
        this._events.add(event);
    }

    public void processDecodes(final FacesContext context) {
        this.checkNull(context, "context");
        this.process(context, PhaseId.APPLY_REQUEST_VALUES, new Processor(){

            public void process() {
                UIViewRoot.super.processDecodes(context);
            }
        }, true);
    }

    public void processValidators(final FacesContext context) {
        this.checkNull(context, "context");
        this.process(context, PhaseId.PROCESS_VALIDATIONS, new Processor(){

            public void process() {
                UIViewRoot.super.processValidators(context);
            }
        }, true);
    }

    public void processUpdates(final FacesContext context) {
        this.checkNull(context, "context");
        this.process(context, PhaseId.UPDATE_MODEL_VALUES, new Processor(){

            public void process() {
                UIViewRoot.super.processUpdates(context);
            }
        }, true);
    }

    public void processApplication(FacesContext context) {
        this.checkNull(context, "context");
        this.process(context, PhaseId.INVOKE_APPLICATION, null, true);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.checkNull(context, "context");
        boolean skipPhase = false;
        try {
            skipPhase = this.notifyListeners(context, PhaseId.RENDER_RESPONSE, this.getBeforePhaseListener(), true);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception while processing phase listener: " + e.getMessage(), e);
        }
        if (!skipPhase) {
            super.encodeBegin(context);
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        this.checkNull(context, "context");
        super.encodeEnd(context);
        try {
            this.notifyListeners(context, PhaseId.RENDER_RESPONSE, this.getAfterPhaseListener(), false);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Exception while processing phase listener: " + e.getMessage(), e);
        }
    }

    public String createUniqueId() {
        StringBuilder bld = UIViewRoot.__getSharedStringBuilder();
        return bld.append(UNIQUE_ID_PREFIX).append(this._uniqueIdCounter++).toString();
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        ValueExpression expression = this.getValueExpression("locale");
        if (expression != null) {
            return (Locale)expression.getValue(this.getFacesContext().getELContext());
        }
        Locale locale = this.getFacesContext().getApplication().getViewHandler().calculateLocale(this.getFacesContext());
        if (locale instanceof Locale) {
            return locale;
        }
        if (locale instanceof String) {
            return this.stringToLocale((String)((Object)locale));
        }
        return this.getFacesContext().getApplication().getViewHandler().calculateLocale(this.getFacesContext());
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    private boolean process(FacesContext context, PhaseId phaseId, Processor processor, boolean broadcast) {
        if (!this.notifyListeners(context, phaseId, this.getBeforePhaseListener(), true)) {
            if (processor != null) {
                processor.process();
            }
            if (broadcast) {
                this._broadcastForPhase(phaseId);
            }
        }
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
        return this.notifyListeners(context, phaseId, this.getAfterPhaseListener(), false);
    }

    private boolean notifyListeners(FacesContext context, PhaseId phaseId, MethodExpression listener, boolean beforePhase) {
        boolean skipPhase = false;
        if (listener != null || this._phaseListeners != null && !this._phaseListeners.isEmpty()) {
            PhaseEvent event = this.createEvent(context, phaseId);
            if (listener != null) {
                listener.invoke(context.getELContext(), new Object[]{event});
                boolean bl = skipPhase = context.getResponseComplete() || context.getRenderResponse();
            }
            if (this._phaseListeners != null && !this._phaseListeners.isEmpty()) {
                for (PhaseListener phaseListener : this._phaseListeners) {
                    PhaseId listenerPhaseId = phaseListener.getPhaseId();
                    if (!phaseId.equals(listenerPhaseId) && !PhaseId.ANY_PHASE.equals(listenerPhaseId)) continue;
                    if (beforePhase) {
                        phaseListener.beforePhase(event);
                    } else {
                        phaseListener.afterPhase(event);
                    }
                    skipPhase = context.getResponseComplete() || context.getRenderResponse();
                }
            }
        }
        return skipPhase;
    }

    private PhaseEvent createEvent(FacesContext context, PhaseId phaseId) {
        if (this._lifecycle == null) {
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String id = context.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
            if (id == null) {
                id = "DEFAULT";
            }
            this._lifecycle = factory.getLifecycle(id);
        }
        return new PhaseEvent(context, phaseId, this._lifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _broadcastForPhase(PhaseId phaseId) {
        if (this._events == null) {
            return;
        }
        boolean abort = false;
        int phaseIdOrdinal = phaseId.getOrdinal();
        ListIterator<FacesEvent> listiterator = this._events.listIterator();
        while (listiterator.hasNext()) {
            FacesEvent event = listiterator.next();
            int ordinal = event.getPhaseId().getOrdinal();
            if (ordinal != ANY_PHASE_ORDINAL && ordinal != phaseIdOrdinal) continue;
            UIComponent source = event.getComponent();
            try {
                source.broadcast(event);
            }
            catch (AbortProcessingException e) {
                abort = true;
                break;
            }
            finally {
                try {
                    listiterator.remove();
                }
                catch (ConcurrentModificationException cme) {
                    int eventIndex = listiterator.previousIndex();
                    this._events.remove(eventIndex);
                    listiterator = this._events.listIterator();
                }
            }
        }
        if (abort) {
            this.clearEvents();
        }
    }

    private void clearEvents() {
        this._events = null;
    }

    private void checkNull(Object value, String valueLabel) {
        if (value == null) {
            throw new NullPointerException(valueLabel + " is null");
        }
    }

    private Locale stringToLocale(String localeStr) {
        if (localeStr.contains("_") || localeStr.contains("-")) {
            if (localeStr.length() == 2) {
                return new Locale(localeStr);
            }
        } else if (localeStr.length() == 5) {
            String lang = localeStr.substring(0, 1);
            String country = localeStr.substring(3, 4);
            return new Locale(lang, country);
        }
        return Locale.getDefault();
    }

    public String getRenderKitId() {
        if (this._renderKitId != null) {
            return this._renderKitId;
        }
        ValueExpression expression = this.getValueExpression("renderKitId");
        if (expression != null) {
            return (String)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setRenderKitId(String renderKitId) {
        this._renderKitId = renderKitId;
    }

    public void setRendered(boolean state) {
        super.setRendered(state);
    }

    public boolean isRendered() {
        return super.isRendered();
    }

    public void setId(String id) {
        super.setId(id);
    }

    public String getId() {
        return super.getId();
    }

    public String getClientId(FacesContext context) {
        return super.getClientId(context);
    }

    public String getViewId() {
        return this._viewId;
    }

    public void setViewId(String viewId) {
        this._viewId = viewId;
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException("phaseListener");
        }
        if (this._phaseListeners == null) {
            this._phaseListeners = new ArrayList<PhaseListener>();
        }
        this._phaseListeners.add(phaseListener);
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null || this._phaseListeners == null) {
            return;
        }
        this._phaseListeners.remove(phaseListener);
    }

    public MethodExpression getBeforePhaseListener() {
        if (this._beforePhaseListener != null) {
            return this._beforePhaseListener;
        }
        ValueExpression expression = this.getValueExpression("beforePhaseListener");
        if (expression != null) {
            return (MethodExpression)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setBeforePhaseListener(MethodExpression beforePhaseListener) {
        this._beforePhaseListener = beforePhaseListener;
    }

    public MethodExpression getAfterPhaseListener() {
        if (this._afterPhaseListener != null) {
            return this._afterPhaseListener;
        }
        ValueExpression expression = this.getValueExpression("afterPhaseListener");
        if (expression != null) {
            return (MethodExpression)expression.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAfterPhaseListener(MethodExpression afterPhaseListener) {
        this._afterPhaseListener = afterPhaseListener;
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{super.saveState(facesContext), this._locale, this._renderKitId, this._viewId, this._uniqueIdCounter, UIViewRoot.saveAttachedState(facesContext, this._phaseListeners), UIViewRoot.saveAttachedState(facesContext, this._beforePhaseListener), UIViewRoot.saveAttachedState(facesContext, this._afterPhaseListener)};
        return values;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(facesContext, values[0]);
        this._locale = (Locale)values[1];
        this._renderKitId = (String)values[2];
        this._viewId = (String)values[3];
        this._uniqueIdCounter = (Long)values[4];
        this._phaseListeners = (List)UIViewRoot.restoreAttachedState(facesContext, values[5]);
        this._beforePhaseListener = (MethodExpression)UIViewRoot.restoreAttachedState(facesContext, values[6]);
        this._afterPhaseListener = (MethodExpression)UIViewRoot.restoreAttachedState(facesContext, values[7]);
    }

    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    private static interface Processor {
        public void process();
    }
}

