/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.ProjectStage;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;
import org.apache.myfaces.application.DefaultNavigationHandlerSupport;
import org.apache.myfaces.application.NavigationHandlerSupport;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.shared.application.NavigationUtils;
import org.apache.myfaces.shared.renderkit.html.util.SharedStringBuilder;
import org.apache.myfaces.shared.util.HashMapUtils;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.view.facelets.tag.jsf.PreDisposeViewEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private static final Logger log = Logger.getLogger(NavigationHandlerImpl.class.getName());
    private static final String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private static final Set<VisitHint> VISIT_HINTS = Collections.unmodifiableSet(EnumSet.of(VisitHint.SKIP_ITERATION));
    private static final String OUTCOME_NAVIGATION_SB = "oam.navigation.OUTCOME_NAVIGATION_SB";
    private static final Pattern AMP_PATTERN = Pattern.compile("&(amp;)?");
    private static final String ASTERISK = "*";
    private Map<String, Set<NavigationCase>> _navigationCases = null;
    private List<String> _wildcardKeys = new ArrayList<String>();
    private Boolean _developmentStage;
    private NavigationHandlerSupport navigationHandlerSupport;

    public NavigationHandlerImpl() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New NavigationHandler instance created");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        NavigationCase navigationCase = this.getNavigationCase(facesContext, fromAction, outcome);
        if (navigationCase != null) {
            ViewMetadata metadata;
            ViewDeclarationLanguage vdl;
            String viewId;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("handleNavigation fromAction=" + fromAction + " outcome=" + outcome + " toViewId =" + navigationCase.getToViewId(facesContext) + " redirect=" + navigationCase.isRedirect());
            }
            if (navigationCase.isRedirect()) {
                String viewId2;
                Map viewMap;
                ExternalContext externalContext = facesContext.getExternalContext();
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                String toViewId = navigationCase.getToViewId(facesContext);
                String redirectPath = viewHandler.getRedirectURL(facesContext, toViewId, NavigationUtils.getEvaluatedNavigationParameters(facesContext, navigationCase.getParameters()), navigationCase.isIncludeViewParams());
                UIViewRoot viewRoot = facesContext.getViewRoot();
                if (viewRoot != null && !toViewId.equals(viewRoot.getViewId()) && (viewMap = viewRoot.getViewMap(false)) != null) {
                    viewMap.clear();
                }
                PartialViewContext partialViewContext = facesContext.getPartialViewContext();
                String string = viewId2 = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : null;
                if (partialViewContext.isPartialRequest() && !partialViewContext.isRenderAll() && toViewId != null && !toViewId.equals(viewId2)) {
                    partialViewContext.setRenderAll(true);
                }
                externalContext.getFlash().setRedirect(true);
                try {
                    externalContext.redirect(redirectPath);
                    facesContext.responseComplete();
                }
                catch (IOException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
            }
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            String newViewId = navigationCase.getToViewId(facesContext);
            PartialViewContext partialViewContext = facesContext.getPartialViewContext();
            String string = viewId = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : null;
            if (partialViewContext.isPartialRequest() && !partialViewContext.isRenderAll() && newViewId != null && !newViewId.equals(viewId)) {
                partialViewContext.setRenderAll(true);
            }
            if (facesContext.getViewRoot() != null && facesContext.getViewRoot().getAttributes().containsKey("oam.CALL_PRE_DISPOSE_VIEW")) {
                try {
                    facesContext.getAttributes().put(SKIP_ITERATION_HINT, Boolean.TRUE);
                    VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, VISIT_HINTS);
                    facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)new PreDisposeViewCallback());
                }
                finally {
                    facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
                }
            }
            UIViewRoot viewRoot = null;
            String derivedViewId = viewHandler.deriveViewId(facesContext, newViewId);
            if (derivedViewId != null && (vdl = viewHandler.getViewDeclarationLanguage(facesContext, derivedViewId)) != null && (metadata = vdl.getViewMetadata(facesContext, newViewId)) != null) {
                viewRoot = metadata.createMetadataView(facesContext);
            }
            if (viewRoot == null) {
                viewRoot = viewHandler.createView(facesContext, newViewId);
            }
            facesContext.setViewRoot(viewRoot);
            facesContext.renderResponse();
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("handleNavigation fromAction=" + fromAction + " outcome=" + outcome + " no matching navigation-case found, staying on current ViewRoot");
        }
    }

    protected NavigationHandlerSupport getNavigationHandlerSupport() {
        if (this.navigationHandlerSupport == null) {
            this.navigationHandlerSupport = new DefaultNavigationHandlerSupport();
        }
        return this.navigationHandlerSupport;
    }

    public void setNavigationHandlerSupport(NavigationHandlerSupport navigationHandlerSupport) {
        this.navigationHandlerSupport = navigationHandlerSupport;
    }

    public NavigationCase getNavigationCase(FacesContext facesContext, String fromAction, String outcome) {
        Set<NavigationCase> casesSet;
        String viewId = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : null;
        Map<String, Set<NavigationCase>> casesMap = this.getNavigationCases();
        NavigationCase navigationCase = null;
        if (viewId != null && (casesSet = casesMap.get(viewId)) != null) {
            navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome);
        }
        if (navigationCase == null) {
            List<String> sortedWildcardKeys = this.getSortedWildcardKeys();
            for (int i = 0; i < sortedWildcardKeys.size(); ++i) {
                String fromViewId = sortedWildcardKeys.get(i);
                if (fromViewId.length() > 2) {
                    String prefix = fromViewId.substring(0, fromViewId.length() - 1);
                    if (viewId == null || !viewId.startsWith(prefix) || (casesSet = casesMap.get(fromViewId)) == null || (navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome)) == null) continue;
                    break;
                }
                casesSet = casesMap.get(fromViewId);
                if (casesSet != null && (navigationCase = this.calcMatchingNavigationCase(facesContext, casesSet, fromAction, outcome)) != null) break;
            }
        }
        if (outcome != null && navigationCase == null) {
            navigationCase = this.getOutcomeNavigationCase(facesContext, fromAction, outcome);
        }
        if (outcome != null && navigationCase == null && !facesContext.isProjectStage(ProjectStage.Production)) {
            FacesMessage facesMessage = new FacesMessage("No navigation case match for viewId " + viewId + ",  action " + fromAction + " and outcome " + outcome);
            facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
            facesContext.addMessage(null, facesMessage);
        }
        return navigationCase;
    }

    private NavigationCase getOutcomeNavigationCase(FacesContext facesContext, String fromAction, String outcome) {
        String implicitViewId = null;
        boolean includeViewParams = false;
        boolean isRedirect = false;
        String queryString = null;
        NavigationCase result = null;
        String viewId = facesContext.getViewRoot() != null ? facesContext.getViewRoot().getViewId() : null;
        StringBuilder viewIdToTest = SharedStringBuilder.get(facesContext, OUTCOME_NAVIGATION_SB);
        viewIdToTest.append(outcome);
        int index = viewIdToTest.indexOf("?");
        if (index != -1) {
            queryString = viewIdToTest.substring(index + 1);
            viewIdToTest.setLength(index);
            if (queryString.indexOf("faces-redirect=true") != -1) {
                isRedirect = true;
            }
            if (queryString.indexOf("includeViewParams=true") != -1 || queryString.indexOf("faces-include-view-params=true") != -1) {
                includeViewParams = true;
            }
        }
        if ((index = viewIdToTest.indexOf(".")) == -1) {
            if (viewId != null) {
                index = viewId.lastIndexOf(".");
                if (index != -1) {
                    viewIdToTest.append(viewId.substring(index));
                }
            } else {
                String tempViewId = this.getNavigationHandlerSupport().calculateViewId(facesContext);
                if (tempViewId != null && (index = tempViewId.lastIndexOf(".")) != -1) {
                    viewIdToTest.append(tempViewId.substring(index));
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("getOutcomeNavigationCase -> viewIdToTest: " + viewIdToTest);
            }
        }
        boolean startWithSlash = false;
        if (viewIdToTest.length() > 0) {
            boolean bl = startWithSlash = viewIdToTest.charAt(0) == '/';
        }
        if (!startWithSlash) {
            index = -1;
            if (viewId != null) {
                index = viewId.lastIndexOf("/");
            }
            if (index == -1) {
                viewIdToTest.insert(0, "/");
            } else {
                viewIdToTest.insert(0, viewId, 0, index + 1);
            }
        }
        try {
            implicitViewId = facesContext.getApplication().getViewHandler().deriveViewId(facesContext, viewIdToTest.toString());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (implicitViewId != null) {
            HashMap<String, ArrayList<String>> params = null;
            if (queryString != null && !"".equals(queryString)) {
                String[] splitQueryParams = AMP_PATTERN.split(queryString);
                params = new HashMap<String, ArrayList<String>>(splitQueryParams.length, (splitQueryParams.length * 4 + 3) / 3);
                for (String queryParam : splitQueryParams) {
                    String[] splitParam = StringUtils.splitShortString(queryParam, '=');
                    if (splitParam.length == 2) {
                        if ("includeViewParams".equals(splitParam[0]) || "faces-include-view-params".equals(splitParam[0]) || "faces-redirect".equals(splitParam[0])) continue;
                        ArrayList<String> paramValues = (ArrayList<String>)params.get(splitParam[0]);
                        if (paramValues == null) {
                            paramValues = new ArrayList<String>();
                            params.put(splitParam[0], paramValues);
                        }
                        paramValues.add(splitParam[1]);
                        continue;
                    }
                    throw new FacesException("Invalid parameter \"" + queryParam + "\" in outcome " + outcome);
                }
            }
            result = new NavigationCase(viewId, fromAction, outcome, null, implicitViewId, params, isRedirect, includeViewParams);
        }
        return result;
    }

    public String getViewId(FacesContext context, String fromAction, String outcome) {
        return this.getNavigationCase(context, fromAction, outcome).getToViewId(context);
    }

    public String beforeNavigation(String viewId) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private NavigationCase calcMatchingNavigationCase(FacesContext context, Set<? extends NavigationCase> casesList, String actionRef, String outcome) {
        NavigationCase noConditionCase = null;
        NavigationCase firstCase = null;
        NavigationCase firstCaseIf = null;
        NavigationCase secondCase = null;
        NavigationCase secondCaseIf = null;
        NavigationCase thirdCase = null;
        NavigationCase thirdCaseIf = null;
        NavigationCase fourthCase = null;
        NavigationCase fourthCaseIf = null;
        for (NavigationCase navigationCase : casesList) {
            boolean ifMatches;
            Boolean cazeIf;
            block19: {
                String cazeOutcome;
                block18: {
                    cazeOutcome = navigationCase.getFromOutcome();
                    String cazeActionRef = navigationCase.getFromAction();
                    cazeIf = navigationCase.getCondition(context);
                    boolean bl = ifMatches = cazeIf == null ? false : cazeIf;
                    if (outcome == null && (cazeOutcome != null || cazeIf == null) && actionRef == null) continue;
                    if (cazeOutcome == null && cazeActionRef == null && cazeIf == null && noConditionCase == null && outcome != null) {
                        noConditionCase = navigationCase;
                    }
                    if (cazeActionRef == null) break block18;
                    if (cazeOutcome != null) {
                        if (actionRef != null && outcome != null && cazeActionRef.equals(actionRef) && cazeOutcome.equals(outcome)) {
                            if (cazeIf != null) {
                                if (!ifMatches) continue;
                                firstCaseIf = navigationCase;
                                continue;
                            }
                            firstCase = navigationCase;
                        }
                        break block19;
                    } else {
                        if (actionRef == null || !cazeActionRef.equals(actionRef)) continue;
                        if (cazeIf != null) {
                            if (!ifMatches) continue;
                            thirdCaseIf = navigationCase;
                            continue;
                        }
                        if (outcome == null) continue;
                        thirdCase = navigationCase;
                        continue;
                    }
                }
                if (cazeOutcome != null && outcome != null && cazeOutcome.equals(outcome)) {
                    if (cazeIf != null) {
                        if (!ifMatches) continue;
                        secondCaseIf = navigationCase;
                        continue;
                    }
                    secondCase = navigationCase;
                }
            }
            if (outcome != null && cazeIf != null) {
                if (!ifMatches) continue;
                fourthCaseIf = navigationCase;
                continue;
            }
            if (cazeIf == null || !ifMatches) continue;
            fourthCase = navigationCase;
        }
        if (firstCaseIf != null) {
            return firstCaseIf;
        }
        if (firstCase != null) {
            return firstCase;
        }
        if (secondCaseIf != null) {
            return secondCaseIf;
        }
        if (secondCase != null) {
            return secondCase;
        }
        if (thirdCaseIf != null) {
            return thirdCaseIf;
        }
        if (thirdCase != null) {
            return thirdCase;
        }
        if (fourthCaseIf != null) {
            return fourthCaseIf;
        }
        if (fourthCase != null) {
            return fourthCase;
        }
        return noConditionCase;
    }

    private List<String> getSortedWildcardKeys() {
        return this._wildcardKeys;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this._developmentStage == null) {
            this._developmentStage = FacesContext.getCurrentInstance().isProjectStage(ProjectStage.Development);
        }
        if (!Boolean.TRUE.equals(this._developmentStage)) {
            if (this._navigationCases == null) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                ExternalContext externalContext = facesContext.getExternalContext();
                RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
                this.calculateNavigationCases(facesContext, runtimeConfig);
            }
            return this._navigationCases;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = facesContext.getExternalContext();
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(externalContext);
        if (this._navigationCases == null || runtimeConfig.isNavigationRulesChanged()) {
            this.calculateNavigationCases(facesContext, runtimeConfig);
        }
        return this._navigationCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void calculateNavigationCases(FacesContext facesContext, RuntimeConfig runtimeConfig) {
        if (this._navigationCases == null || runtimeConfig.isNavigationRulesChanged()) {
            Collection<NavigationRule> rules = runtimeConfig.getNavigationRules();
            int rulesSize = rules.size();
            HashMap<String, Set<NavigationCase>> cases = new HashMap<String, Set<NavigationCase>>(HashMapUtils.calcCapacity(rulesSize));
            ArrayList<String> wildcardKeys = new ArrayList<String>();
            for (NavigationRule rule : rules) {
                String fromViewId = rule.getFromViewId();
                fromViewId = fromViewId == null ? ASTERISK : fromViewId.trim();
                HashSet<NavigationCase> set = (HashSet<NavigationCase>)cases.get(fromViewId);
                if (set == null) {
                    set = new HashSet<NavigationCase>(this.convertNavigationCasesToAPI(rule));
                    cases.put(fromViewId, set);
                    if (!fromViewId.endsWith(ASTERISK)) continue;
                    wildcardKeys.add(fromViewId);
                    continue;
                }
                set.addAll(this.convertNavigationCasesToAPI(rule));
            }
            Collections.sort(wildcardKeys, new KeyComparator());
            HashMap<String, Set<NavigationCase>> hashMap = cases;
            synchronized (hashMap) {
                this._navigationCases = cases;
                this._wildcardKeys = wildcardKeys;
                runtimeConfig.setNavigationRulesChanged(false);
            }
        }
    }

    private Set<NavigationCase> convertNavigationCasesToAPI(NavigationRule rule) {
        Collection<? extends org.apache.myfaces.config.element.NavigationCase> configCases = rule.getNavigationCases();
        HashSet<NavigationCase> apiCases = new HashSet<NavigationCase>(configCases.size());
        for (org.apache.myfaces.config.element.NavigationCase navigationCase : configCases) {
            if (navigationCase.getRedirect() != null) {
                String includeViewParamsAttribute = navigationCase.getRedirect().getIncludeViewParams();
                boolean includeViewParams = false;
                if (includeViewParamsAttribute != null) {
                    includeViewParams = new Boolean(includeViewParamsAttribute);
                }
                apiCases.add(new NavigationCase(rule.getFromViewId(), navigationCase.getFromAction(), navigationCase.getFromOutcome(), navigationCase.getIf(), navigationCase.getToViewId(), navigationCase.getRedirect().getViewParams(), true, includeViewParams));
                continue;
            }
            apiCases.add(new NavigationCase(rule.getFromViewId(), navigationCase.getFromAction(), navigationCase.getFromOutcome(), navigationCase.getIf(), navigationCase.getToViewId(), null, false, false));
        }
        return apiCases;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyComparator
    implements Comparator<String> {
        private KeyComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return -s1.compareTo(s2);
        }
    }

    private static class PreDisposeViewCallback
    implements VisitCallback {
        private PreDisposeViewCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            context.getFacesContext().getApplication().publishEvent(context.getFacesContext(), PreDisposeViewEvent.class, (Object)target);
            return VisitResult.ACCEPT;
        }
    }
}

