/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.pool.impl;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.myfaces.view.facelets.pool.ViewEntry;

public class ViewPoolEntryHolder {
    private Queue<ViewEntry> queue = new ConcurrentLinkedQueue<ViewEntry>();
    private AtomicInteger count = new AtomicInteger();
    private int maxCount;

    public ViewPoolEntryHolder(int maxCount) {
        this.maxCount = maxCount;
    }

    public boolean add(ViewEntry entry) {
        if (this.count.get() < this.maxCount) {
            this.queue.add(entry);
            this.count.incrementAndGet();
            return true;
        }
        return false;
    }

    public ViewEntry poll() {
        ViewEntry entry = this.queue.poll();
        this.count.decrementAndGet();
        return entry;
    }

    public boolean isFull() {
        return this.count.get() >= this.maxCount;
    }

    public int getCount() {
        return this.count.get();
    }
}

