/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import jakarta.el.ELResolver;
import jakarta.el.ExpressionFactory;
import jakarta.faces.component.search.SearchKeywordResolver;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.NamedEventManager;
import org.apache.myfaces.config.element.ComponentTagDeclaration;
import org.apache.myfaces.config.element.Converter;
import org.apache.myfaces.config.element.FaceletsProcessing;
import org.apache.myfaces.config.element.FaceletsTemplateMapping;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.ResourceBundle;
import org.apache.myfaces.config.element.ViewPoolMapping;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;
import org.apache.myfaces.core.api.shared.lang.Assert;

public class RuntimeConfig {
    private static final Logger log = Logger.getLogger(RuntimeConfig.class.getName());
    private static final String APPLICATION_MAP_PARAM_NAME = RuntimeConfig.class.getName();
    private final Collection<NavigationRule> _navigationRules = new ArrayList<NavigationRule>();
    private boolean _navigationRulesChanged = false;
    private final Map<String, ResourceBundle> _resourceBundles = new HashMap<String, ResourceBundle>();
    private String _facesVersion;
    private List<ELResolver> facesConfigElResolvers;
    private List<ELResolver> applicationElResolvers;
    private ExpressionFactory _expressionFactory;
    private Comparator<ELResolver> _elResolverComparator;
    private Predicate<ELResolver> _elResolverPredicate;
    private final Map<String, Converter> _converterClassNameToConfigurationMap = new ConcurrentHashMap<String, Converter>();
    private NamedEventManager _namedEventManager;
    private final Map<String, FaceletsProcessing> _faceletsProcessingByFileExtension = new HashMap<String, FaceletsProcessing>();
    private Set<String> _externalContextResourceLibraryContracts = new HashSet<String>();
    private Set<String> _classLoaderResourceLibraryContracts = new HashSet<String>();
    private Set<String> _resourceLibraryContracts = new HashSet<String>();
    private Map<String, List<String>> _contractMappings = new HashMap<String, List<String>>();
    private List<ComponentTagDeclaration> _componentTagDeclarations = new ArrayList<ComponentTagDeclaration>();
    private List<String> _resourceResolvers = new ArrayList<String>();
    private List<FaceletTagLibrary> _faceletTagLibraries = new ArrayList<FaceletTagLibrary>();
    private Map<Integer, String> _namespaceById = new HashMap<Integer, String>();
    private Map<String, Integer> _idByNamespace = new HashMap<String, Integer>();
    private List<ViewPoolMapping> _viewPoolMappings = new ArrayList<ViewPoolMapping>();
    private List<FaceletsTemplateMapping> _faceletsTemplateMappings = new ArrayList<FaceletsTemplateMapping>();
    private List<SearchKeywordResolver> _searchExpressionResolvers = new ArrayList<SearchKeywordResolver>();
    private List<String> _faceletTemplates = new ArrayList<String>();

    public static RuntimeConfig getCurrentInstance(FacesContext facesContext) {
        return RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
    }

    public static RuntimeConfig getCurrentInstance(ExternalContext externalContext) {
        return (RuntimeConfig)externalContext.getApplicationMap().computeIfAbsent(APPLICATION_MAP_PARAM_NAME, k -> new RuntimeConfig());
    }

    public void purge() {
        this._navigationRules.clear();
        this._navigationRulesChanged = false;
        this._converterClassNameToConfigurationMap.clear();
        this._externalContextResourceLibraryContracts.clear();
        this._classLoaderResourceLibraryContracts.clear();
        this._resourceLibraryContracts.clear();
        this._faceletTagLibraries.clear();
        this._faceletTemplates.clear();
        this._resourceBundles.clear();
        if (this.facesConfigElResolvers != null) {
            this.facesConfigElResolvers.clear();
        }
        if (this.applicationElResolvers != null) {
            this.applicationElResolvers.clear();
        }
        this._faceletsProcessingByFileExtension.clear();
        this._contractMappings.clear();
        this._componentTagDeclarations.clear();
        this._resourceResolvers.clear();
        this._namespaceById = new HashMap<Integer, String>();
        this._idByNamespace = new HashMap<String, Integer>();
        this._viewPoolMappings.clear();
        this._faceletsTemplateMappings.clear();
    }

    public Collection<NavigationRule> getNavigationRules() {
        return Collections.unmodifiableCollection(this._navigationRules);
    }

    public void addNavigationRule(NavigationRule navigationRule) {
        this._navigationRules.add(navigationRule);
        this._navigationRulesChanged = true;
    }

    public boolean isNavigationRulesChanged() {
        return this._navigationRulesChanged;
    }

    public void setNavigationRulesChanged(boolean navigationRulesChanged) {
        this._navigationRulesChanged = navigationRulesChanged;
    }

    public void addComponentTagDeclaration(ComponentTagDeclaration declaration) {
        this._componentTagDeclarations.add(declaration);
    }

    public List<ComponentTagDeclaration> getComponentTagDeclarations() {
        return Collections.unmodifiableList(this._componentTagDeclarations);
    }

    public void addFaceletTagLibrary(FaceletTagLibrary library) {
        this._faceletTagLibraries.add(library);
    }

    public List<FaceletTagLibrary> getFaceletTagLibraries() {
        return Collections.unmodifiableList(this._faceletTagLibraries);
    }

    public final void addConverterConfiguration(String converterClassName, Converter configuration) {
        Assert.notEmpty(converterClassName, "converterClassName");
        Assert.notNull(configuration, "configuration");
        this._converterClassNameToConfigurationMap.put(converterClassName, configuration);
    }

    public Converter getConverterConfiguration(String converterClassName) {
        return this._converterClassNameToConfigurationMap.get(converterClassName);
    }

    public ResourceBundle getResourceBundle(String name) {
        return this._resourceBundles.get(name);
    }

    public Map<String, ResourceBundle> getResourceBundles() {
        return this._resourceBundles;
    }

    public void addResourceBundle(ResourceBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        String var = bundle.getVar();
        if (this._resourceBundles.containsKey(var) && log.isLoggable(Level.WARNING)) {
            log.warning("Another resource bundle for var '" + var + "' with base name '" + this._resourceBundles.get(var).getBaseName() + "' is already registered. '" + this._resourceBundles.get(var).getBaseName() + "' will be replaced with '" + bundle.getBaseName() + "'.");
        }
        this._resourceBundles.put(var, bundle);
    }

    public void addFacesConfigElResolver(ELResolver resolver) {
        if (this.facesConfigElResolvers == null) {
            this.facesConfigElResolvers = new ArrayList<ELResolver>();
        }
        this.facesConfigElResolvers.add(resolver);
    }

    public List<ELResolver> getFacesConfigElResolvers() {
        return this.facesConfigElResolvers;
    }

    public void addApplicationElResolver(ELResolver resolver) {
        if (this.applicationElResolvers == null) {
            this.applicationElResolvers = new ArrayList<ELResolver>();
        }
        this.applicationElResolvers.add(resolver);
    }

    public List<ELResolver> getApplicationElResolvers() {
        return this.applicationElResolvers;
    }

    public ExpressionFactory getExpressionFactory() {
        return this._expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this._expressionFactory = expressionFactory;
    }

    public String getFacesVersion() {
        return this._facesVersion;
    }

    void setFacesVersion(String facesVersion) {
        this._facesVersion = facesVersion;
    }

    public NamedEventManager getNamedEventManager() {
        return this._namedEventManager;
    }

    public void setNamedEventManager(NamedEventManager namedEventManager) {
        this._namedEventManager = namedEventManager;
    }

    public Comparator<ELResolver> getELResolverComparator() {
        return this._elResolverComparator;
    }

    public void setELResolverComparator(Comparator<ELResolver> elResolverComparator) {
        this._elResolverComparator = elResolverComparator;
    }

    public Predicate<ELResolver> getELResolverPredicate() {
        return this._elResolverPredicate;
    }

    public void setELResolverPredicate(Predicate<ELResolver> elResolverPredicate) {
        this._elResolverPredicate = elResolverPredicate;
    }

    public void addFaceletProcessingConfiguration(String fileExtension, FaceletsProcessing configuration) {
        Assert.notEmpty(fileExtension, "fileExtension");
        Assert.notNull(configuration, "configuration");
        this._faceletsProcessingByFileExtension.put(fileExtension, configuration);
    }

    public FaceletsProcessing getFaceletProcessingConfiguration(String fileExtensions) {
        return this._faceletsProcessingByFileExtension.get(fileExtensions);
    }

    public Collection<FaceletsProcessing> getFaceletProcessingConfigurations() {
        return this._faceletsProcessingByFileExtension.values();
    }

    public Set<String> getExternalContextResourceLibraryContracts() {
        return this._externalContextResourceLibraryContracts;
    }

    public void setExternalContextResourceLibraryContracts(Set<String> externalContextResourceLibraryContracts) {
        this._externalContextResourceLibraryContracts = externalContextResourceLibraryContracts;
        this._resourceLibraryContracts.clear();
        this._resourceLibraryContracts.addAll(this._externalContextResourceLibraryContracts);
        this._resourceLibraryContracts.addAll(this._classLoaderResourceLibraryContracts);
    }

    public Set<String> getClassLoaderResourceLibraryContracts() {
        return this._classLoaderResourceLibraryContracts;
    }

    public void setClassLoaderResourceLibraryContracts(Set<String> classLoaderResourceLibraryContracts) {
        this._classLoaderResourceLibraryContracts = classLoaderResourceLibraryContracts;
        this._resourceLibraryContracts.clear();
        this._resourceLibraryContracts.addAll(this._externalContextResourceLibraryContracts);
        this._resourceLibraryContracts.addAll(this._classLoaderResourceLibraryContracts);
    }

    public Set<String> getResourceLibraryContracts() {
        return this._resourceLibraryContracts;
    }

    public Map<String, List<String>> getContractMappings() {
        return this._contractMappings;
    }

    public void addContractMapping(String urlPattern, String[] contracts) {
        List contractsList = this._contractMappings.computeIfAbsent(urlPattern, k -> new ArrayList());
        Collections.addAll(contractsList, contracts);
    }

    public void addContractMapping(String urlPattern, String contract) {
        List contractsList = this._contractMappings.computeIfAbsent(urlPattern, k -> new ArrayList());
        contractsList.add(contract);
    }

    public List<String> getResourceResolvers() {
        return this._resourceResolvers;
    }

    public void addResourceResolver(String resourceResolver) {
        this._resourceResolvers.add(resourceResolver);
    }

    public Map<Integer, String> getNamespaceById() {
        return this._namespaceById;
    }

    public void setNamespaceById(Map<Integer, String> namespaceById) {
        this._namespaceById = namespaceById;
    }

    public Map<String, Integer> getIdByNamespace() {
        return this._idByNamespace;
    }

    public void setIdByNamespace(Map<String, Integer> idByNamespace) {
        this._idByNamespace = idByNamespace;
    }

    public List<ViewPoolMapping> getViewPoolMappings() {
        return this._viewPoolMappings;
    }

    public void addViewPoolMapping(ViewPoolMapping mapping) {
        this._viewPoolMappings.add(mapping);
    }

    public void addApplicationSearchExpressionResolver(SearchKeywordResolver resolver) {
        if (this._searchExpressionResolvers == null) {
            this._searchExpressionResolvers = new ArrayList<SearchKeywordResolver>();
        }
        this._searchExpressionResolvers.add(resolver);
    }

    public List<SearchKeywordResolver> getApplicationSearchExpressionResolvers() {
        return this._searchExpressionResolvers;
    }

    public List<FaceletsTemplateMapping> getFaceletsTemplateMappings() {
        return this._faceletsTemplateMappings;
    }

    public void addFaceletsTemplateMapping(FaceletsTemplateMapping mapping) {
        this._faceletsTemplateMappings.add(mapping);
    }
}

