/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.event;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import jakarta.faces.event.SystemEventListenerHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExceptionQueuedEventContext
implements SystemEventListenerHolder {
    public static final String IN_AFTER_PHASE_KEY = ExceptionQueuedEventContext.class.getName() + ".IN_AFTER_PHASE";
    public static final String IN_BEFORE_PHASE_KEY = ExceptionQueuedEventContext.class.getName() + ".IN_BEFORE_PHASE";
    private Map<Object, Object> _attributes;
    private UIComponent _component;
    private FacesContext _context;
    private PhaseId _phase;
    private Throwable _thrown;

    public ExceptionQueuedEventContext(FacesContext context, Throwable thrown) {
        this(context, thrown, null);
    }

    public ExceptionQueuedEventContext(FacesContext context, Throwable thrown, UIComponent component) {
        this(context, thrown, component, null);
    }

    public ExceptionQueuedEventContext(FacesContext context, Throwable thrown, UIComponent component, PhaseId phaseId) {
        this._context = context;
        this._thrown = thrown;
        this._component = component;
        this._phase = phaseId == null ? context.getCurrentPhaseId() : phaseId;
    }

    public Map<Object, Object> getAttributes() {
        if (this._attributes == null) {
            this._attributes = new HashMap<Object, Object>();
        }
        return this._attributes;
    }

    public UIComponent getComponent() {
        return this._component;
    }

    public FacesContext getContext() {
        return this._context;
    }

    public Throwable getException() {
        return this._thrown;
    }

    @Override
    public List<SystemEventListener> getListenersForEventClass(Class<? extends SystemEvent> facesEventClass) {
        return Collections.singletonList(this.getContext().getExceptionHandler());
    }

    public PhaseId getPhaseId() {
        return this._phase;
    }

    public boolean inAfterPhase() {
        return this._attributes != null && this._attributes.containsKey(IN_AFTER_PHASE_KEY);
    }

    public boolean inBeforePhase() {
        return this._attributes != null && this._attributes.containsKey(IN_BEFORE_PHASE_KEY);
    }
}

