/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.validation.message.interpolator;

import java.util.Locale;
import javax.validation.MessageInterpolator;
import org.apache.myfaces.extensions.validator.beanval.validation.message.interpolator.DefaultMessageInterpolator;
import org.apache.myfaces.extensions.validator.core.validation.message.resolver.MessageResolver;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValMessageInterpolatorAdapter
extends DefaultMessageInterpolator {
    private MessageResolver messageResolver;

    public ExtValMessageInterpolatorAdapter(MessageInterpolator wrapped, MessageResolver messageResolver) {
        super(wrapped);
        this.messageResolver = messageResolver;
    }

    public String interpolate(String messageOrKey, MessageInterpolator.Context context) {
        return this.interpolate(messageOrKey, context, this.getCurrentLocale());
    }

    public String interpolate(String messageOrKey, MessageInterpolator.Context context, Locale locale) {
        if (this.messageResolver != null) {
            if (this.isBeanValidationMessageKeyFormat(messageOrKey)) {
                String newMessageOrKey = this.messageResolver.getMessage(this.extractKey(messageOrKey), this.getCurrentLocale());
                if (this.isValideMessage(newMessageOrKey)) {
                    messageOrKey = newMessageOrKey;
                }
            } else {
                this.logger.finest("you tried to use an extval message-resolver forjsr303 validation with an invalid key -> using a default interpolator");
            }
        }
        return super.interpolate(messageOrKey, context, this.getCurrentLocale());
    }

    private boolean isBeanValidationMessageKeyFormat(String messageOrKey) {
        return messageOrKey.startsWith("{") && messageOrKey.endsWith("}");
    }

    private String extractKey(String messageOrKey) {
        return messageOrKey.substring(1, messageOrKey.length() - 1);
    }

    private boolean isValideMessage(String newMessageOrKey) {
        return !newMessageOrKey.startsWith("???") || !newMessageOrKey.endsWith("???");
    }
}

