/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.proxy;

import java.util.logging.Logger;
import org.apache.myfaces.extensions.validator.core.proxy.ProxyHelper;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultProxyHelper
implements ProxyHelper {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public DefaultProxyHelper() {
        this.logger.fine(this.getClass().getName() + " instantiated");
    }

    @Override
    public <T> Class<T> getUnproxiedClass(Class currentClass, Class<T> targetType) {
        return this.getUnproxiedClass(currentClass);
    }

    @Override
    public Class getUnproxiedClass(Class currentClass) {
        if (this.isProxiedClass(currentClass)) {
            return currentClass.getSuperclass();
        }
        return currentClass;
    }

    @Override
    public String getNameOfClass(Class currentClass) {
        if (this.isProxiedClass(currentClass)) {
            return currentClass.getSuperclass().getName();
        }
        return currentClass.getName();
    }

    @Override
    public String getClassNameOfObject(Object object) {
        if (object != null) {
            return this.getNameOfClass(object.getClass());
        }
        return null;
    }

    @Override
    public boolean isProxiedClass(Class currentClass) {
        return currentClass.getName().contains("$$EnhancerByCGLIB$$") || currentClass.getName().contains("$$FastClassByCGLIB$$") || currentClass.getName().contains("_$$_javassist");
    }

    @Override
    public boolean isProxiedObject(Object proxiedObject) {
        return proxiedObject != null && this.isProxiedClass(proxiedObject.getClass());
    }
}

