/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.context;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.faces.Bridge;
import javax.servlet.ServletRequest;
import org.apache.myfaces.portlet.faces.context.PortletExternalContextImpl;
import org.apache.myfaces.portlet.faces.context.PortletFacesContextImpl;

public class FacesContextFactoryImpl
extends FacesContextFactory {
    private FacesContextFactory mHandler;

    public FacesContextFactoryImpl(FacesContextFactory handler) {
        this.mHandler = handler;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        if (this.isPortletRequest(request)) {
            if (context instanceof PortletContext && request instanceof PortletRequest && response instanceof PortletResponse) {
                return new PortletFacesContextImpl(new PortletExternalContextImpl((PortletContext)context, (PortletRequest)request, (PortletResponse)response), lifecycle);
            }
            throw new FacesException("getFacesContext failed: Running in a portlet request but not passed portlet objects");
        }
        return this.mHandler.getFacesContext(context, request, response, lifecycle);
    }

    private boolean isPortletRequest(Object request) {
        if (request instanceof ServletRequest) {
            ServletRequest sr = (ServletRequest)request;
            Bridge.PortletPhase phase = (Bridge.PortletPhase)sr.getAttribute("javax.portlet.faces.phase");
            return phase != null;
        }
        return request instanceof PortletRequest;
    }
}

