"use strict";
exports.__esModule = true;
var path = require("path");
var CompressionPlugin = require('compression-webpack-plugin');
/**
 * we need to define the export in a function
 * because the mode parameter is passed down via the argv
 *
 * @param env the environment
 * @param argv the arguments list
 */
function build(env, argv) {
    var _a;
    var libraryTarget = (_a = env.TARGET_TYPE) !== null && _a !== void 0 ? _a : "window";
    var config = {
        context: __dirname,
        entry: {
            jsf: "./src/main/typescript/api/jsf.ts",
            faces: "./src/main/typescript/api/faces.ts"
        },
        devtool: "source-map",
        output: {
            path: path.resolve(__dirname, './dist/' + libraryTarget),
            libraryTarget: libraryTarget,
            filename: (argv.mode == "production") ? "[name].js" : "[name]-development.js"
        },
        resolve: {
            extensions: [".tsx", ".ts", ".json"],
            alias: {
                /*we load the reduced core, because there are some parts we simply do not need*/
                //"mona-dish": path.resolve(__dirname, "node_modules/mona-dish/dist/js/commonjs/index_core.js")
                "mona-dish": path.resolve(__dirname, "node_modules/mona-dish/src/main/typescript/index_core.ts")
            }
        },
        externals: {
            "rxjs": "RxJS"
        },
        module: {
            rules: [
                // all files with a '.ts' or '.tsx' extension will be handled by 'ts-loader'
                {
                    test: /\.tsx?$/, use: [{
                            loader: "ts-loader",
                            options: {
                                allowTsInNodeModules: true
                            }
                        }]
                }
            ]
        },
        plugins: [
            new CompressionPlugin({
                filename: '[name].js.gz[query]',
                algorithm: 'gzip',
                test: /\.js$|\.css$|\.html$|\.eot?.+$|\.ttf?.+$|\.woff?.+$|\.svg?.+$/,
                threshold: 10240,
                minRatio: 0.3
            }),
            new CompressionPlugin({
                filename: '[name].js.br[query]',
                algorithm: 'brotliCompress',
                test: /\.(js|css|html|svg)$/,
                threshold: 10240,
                minRatio: 0.8
            })
        ]
    };
    return config;
}
exports["default"] = build;
//# sourceMappingURL=webpack.config.js.map