"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncRunnable = void 0;
/**
 * pretty much the same as cancellable Promise, but given
 * we do not have that on browser level yet this is sort
 * of a non - intrusive Shim!
 */
class AsyncRunnable {
    constructor() {
        /**
         * helper support so that we do not have to drag in Promise shims
         */
        this.catchFunctions = [];
        this.thenFunctions = [];
    }
    /**
     * resolve handler function which calls the then chain
     * and after that finally
     * @param data
     */
    resolve(data) {
        this.thenFunctions.reduce((inputVal, thenFunc) => {
            return thenFunc(inputVal);
        }, data);
    }
    /**
     * reject handler function which triggers the catch chain
     * @param data
     */
    reject(data) {
        this.catchFunctions.reduce((inputVal, catchFunc) => {
            return catchFunc(inputVal);
        }, data);
    }
    /**
     * register a catch functor
     * @param func the functor for the catch monad
     */
    catch(func) {
        this.catchFunctions.push(func);
        return this;
    }
    /**
     * registers a finally functor
     * @param func the functor for the finally handling chanin
     */
    finally(func) {
        // no ie11 support we probably are going to revert to shims for that one
        this.catchFunctions.push(func);
        this.thenFunctions.push(func);
        return this;
    }
    /**
     * @param func then functor similar to promise
     */
    then(func) {
        this.thenFunctions.push(func);
        return this;
    }
}
exports.AsyncRunnable = AsyncRunnable;
//# sourceMappingURL=AsyncRunnable.js.map