/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.appimage;

import java.nio.file.Path;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.Option;
import org.apache.netbeans.nbpackage.Packager;
import org.apache.netbeans.nbpackage.Template;
import org.apache.netbeans.nbpackage.appimage.AppImageTask;

public class AppImagePackager
implements Packager {
    static final ResourceBundle MESSAGES = ResourceBundle.getBundle(AppImagePackager.class.getPackageName() + ".Messages");
    static final Option<Path> APPIMAGE_TOOL = Option.ofPath("package.appimage.tool", MESSAGES.getString("option.tool.help"));
    static final Option<Path> APPIMAGE_ICON = Option.ofPath("package.appimage.icon", MESSAGES.getString("option.icon.help"));
    static final Option<String> APPIMAGE_CATEGORY = Option.ofString("package.appimage.category", MESSAGES.getString("option.category.default"), MESSAGES.getString("option.category.help"));
    @Deprecated(forRemoval=true)
    static final Option<String> APPIMAGE_ARCH = Option.ofString("package.appimage.arch", MESSAGES.getString("option.arch.help")).withStatus(Option.Status.DEPRECATED);
    static final Option<Path> DESKTOP_TEMPLATE_PATH = Option.ofPath("package.appimage.desktop-template", MESSAGES.getString("option.desktop_template.help"));
    static final Template DESKTOP_TEMPLATE = Template.of(DESKTOP_TEMPLATE_PATH, "AppImage.desktop.template", () -> AppImagePackager.class.getResourceAsStream("AppImage.desktop.template"));
    static final Option<Path> LAUNCHER_TEMPLATE_PATH = Option.ofPath("package.appimage.launcher-template", MESSAGES.getString("option.launcher_template.help"));
    static final Template LAUNCHER_TEMPLATE = Template.of(LAUNCHER_TEMPLATE_PATH, "AppImage.launcher.template", () -> AppImagePackager.class.getResourceAsStream("AppImage.launcher.template"));
    private static final List<Option<?>> APPIMAGE_OPTIONS = List.of(APPIMAGE_TOOL, APPIMAGE_ICON, APPIMAGE_CATEGORY, APPIMAGE_ARCH, DESKTOP_TEMPLATE_PATH, LAUNCHER_TEMPLATE_PATH);
    private static final List<Template> APPIMAGE_TEMPLATES = List.of(DESKTOP_TEMPLATE, LAUNCHER_TEMPLATE);

    @Override
    public Packager.Task createTask(ExecutionContext context) {
        return new AppImageTask(context);
    }

    @Override
    public String name() {
        return "linux-appimage";
    }

    @Override
    public Stream<Option<?>> options() {
        return APPIMAGE_OPTIONS.stream();
    }

    @Override
    public Stream<Template> templates() {
        return APPIMAGE_TEMPLATES.stream();
    }
}

