/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.PropertyKey;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnPurgeOperator;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Sequence;
import io.questdb.std.Chars;
import io.questdb.std.DirectLongList;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.ColumnPurgeTask;
import java.io.Closeable;

public class VacuumColumnVersions
implements Closeable {
    private static final int COLUMN_VERSION_LIST_CAPACITY = 8;
    private static final Log LOG = LogFactory.getLog(VacuumColumnVersions.class);
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final ColumnPurgeTask purgeTask = new ColumnPurgeTask();
    private StringSink fileNameSink;
    private int partitionBy;
    private long partitionTimestamp;
    private Path path2;
    private ColumnPurgeOperator purgeExecution;
    private DirectLongList tableFiles;
    private int tablePathLen;
    private TableReader tableReader;
    private final FindVisitor visitTableFiles = this::visitTableFiles;
    private final FindVisitor visitTablePartition = this::visitTablePartition;

    public VacuumColumnVersions(CairoEngine engine) {
        this.engine = engine;
        this.purgeExecution = new ColumnPurgeOperator(engine.getConfiguration());
        this.tableFiles = new DirectLongList(8L, 27);
        this.ff = engine.getConfiguration().getFilesFacade();
    }

    @Override
    public void close() {
        this.purgeExecution = Misc.free(this.purgeExecution);
        this.tableFiles = Misc.free(this.tableFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SqlExecutionContext executionContext, TableReader reader) {
        executionContext.getCairoSecurityContext().checkWritePermission();
        LOG.info().$("processing [dirName=").utf8(reader.getTableToken().getDirName()).I$();
        this.fileNameSink = new StringSink();
        CairoConfiguration configuration = this.engine.getConfiguration();
        TableToken tableToken = reader.getTableToken();
        Path path = Path.getThreadLocal(configuration.getRoot());
        path.concat(tableToken);
        this.tablePathLen = path.length();
        this.path2 = Path.getThreadLocal2(configuration.getRoot()).concat(tableToken);
        this.tableReader = reader;
        this.partitionBy = reader.getPartitionedBy();
        this.tableFiles.clear();
        try {
            this.ff.iterateDir(path.$(), this.visitTablePartition);
            Vect.sort3LongAscInPlace(this.tableFiles.getAddress(), this.tableFiles.size() / 3L);
            this.purgeColumnVersions(this.tableFiles, reader, this.engine);
        }
        finally {
            this.tableFiles.shrink(8L);
        }
    }

    private static int resolveName2Index(CharSequence name, TableReader tableReader) {
        return tableReader.getMetadata().getColumnIndexQuiet(name);
    }

    private void purgeColumnVersions(DirectLongList tableFiles, TableReader reader, CairoEngine engine) {
        int columnIndex = -1;
        int writerIndex = -1;
        int tableId = reader.getMetadata().getTableId();
        long truncateVersion = reader.getTxFile().getTruncateVersion();
        TableReaderMetadata metadata = reader.getMetadata();
        long updateTxn = reader.getTxn();
        ColumnVersionReader columnVersionReader = reader.getColumnVersionReader();
        this.purgeTask.clear();
        long n = tableFiles.size();
        for (long i = 0L; i < n; i += 3L) {
            long latestColumnNameTxn;
            int newReaderIndex;
            if (tableFiles.get(i) != (long)columnIndex && columnIndex != (newReaderIndex = (int)tableFiles.get(i))) {
                if (columnIndex != -1 && this.purgeTask.getUpdatedColumnInfo().size() > 0) {
                    if (!this.purgeExecution.purge(this.purgeTask, this.tableReader)) {
                        this.queueColumnVersionPurge(this.purgeTask, engine);
                    }
                    this.purgeTask.clear();
                }
                writerIndex = metadata.getWriterIndex(newReaderIndex);
                String columnName = metadata.getColumnName(newReaderIndex);
                int columnType = metadata.getColumnType(newReaderIndex);
                this.purgeTask.of(reader.getTableToken(), columnName, tableId, truncateVersion, columnType, this.partitionBy, updateTxn);
            }
            columnIndex = (int)tableFiles.get(i);
            long partitionTs = tableFiles.get(i + 1L);
            long columnVersion = tableFiles.get(i + 2L);
            if (columnVersion == (latestColumnNameTxn = columnVersionReader.getColumnNameTxn(partitionTs, writerIndex)) || this.versionSetToDelete(this.purgeTask, partitionTs, columnVersion)) continue;
            long partitionNameTxn = reader.getTxFile().getPartitionNameTxnByPartitionTimestamp(partitionTs);
            this.purgeTask.appendColumnInfo(columnVersion, partitionTs, partitionNameTxn);
        }
        if (this.purgeTask.getUpdatedColumnInfo().size() > 0) {
            if (!this.purgeExecution.purge(this.purgeTask, this.tableReader)) {
                this.queueColumnVersionPurge(this.purgeTask, engine);
            }
            this.purgeTask.clear();
        }
    }

    private void queueColumnVersionPurge(ColumnPurgeTask purgeTask, CairoEngine engine) {
        MessageBus messageBus = engine.getMessageBus();
        LOG.info().$("scheduling column version purge [table=").$(purgeTask.getTableName()).$(", column=").$(purgeTask.getColumnName()).I$();
        Sequence pubSeq = messageBus.getColumnPurgePubSeq();
        while (true) {
            long cursor;
            if ((cursor = pubSeq.next()) > -1L) {
                ColumnPurgeTask task = messageBus.getColumnPurgeQueue().get(cursor);
                task.copyFrom(purgeTask);
                pubSeq.done(cursor);
                return;
            }
            if (cursor == -1L) {
                throw CairoException.nonCritical().put("failed to schedule column version purge, queue is full. Please retry and consider increasing ").put(PropertyKey.CAIRO_SQL_COLUMN_PURGE_QUEUE_CAPACITY.getPropertyPath()).put(" configuration parameter");
            }
            Os.pause();
        }
    }

    private boolean versionSetToDelete(ColumnPurgeTask purgeTask, long partitionTs, long columnVersion) {
        LongList columnVersionToDelete = purgeTask.getUpdatedColumnInfo();
        int n = columnVersionToDelete.size();
        for (int i = 0; i < n; i += 4) {
            long cv = columnVersionToDelete.getQuick(i + 0);
            long ts = columnVersionToDelete.getQuick(i + 1);
            if (cv != columnVersion || ts != partitionTs) continue;
            return true;
        }
        return false;
    }

    private void visitTableFiles(long pUtf8NameZ, int type) {
        if (type != 4) {
            int dotIndex;
            this.fileNameSink.clear();
            Chars.utf8DecodeZ(pUtf8NameZ, this.fileNameSink);
            if (Files.notDots(this.fileNameSink) && (dotIndex = Chars.indexOf(this.fileNameSink, '.')) > 0) {
                long columnVersion = -1L;
                CharSequence columnName = this.fileNameSink.subSequence(0, dotIndex);
                int name2Index = VacuumColumnVersions.resolveName2Index(columnName, this.tableReader);
                if (name2Index < 0) {
                    LOG.error().$("file does not belong to the table [name=").$(this.fileNameSink).$(", path=").$(this.path2).I$();
                    return;
                }
                int secondDot = Chars.indexOf(this.fileNameSink, dotIndex + 1, '.');
                int lo = secondDot + 1;
                if (lo < this.fileNameSink.length()) {
                    try {
                        columnVersion = Numbers.parseLong(this.fileNameSink, lo, this.fileNameSink.length());
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                }
                this.tableFiles.add(name2Index);
                this.tableFiles.add(this.partitionTimestamp);
                this.tableFiles.add(columnVersion);
            }
        }
    }

    private void visitTablePartition(long pUtf8NameZ, int type) {
        if (this.ff.isDirOrSoftLinkDirNoDots(this.path2, this.tablePathLen, pUtf8NameZ, type, this.fileNameSink)) {
            this.path2.trimTo(this.tablePathLen).$();
            int dotIndex = Chars.indexOf(this.fileNameSink, '.');
            if (dotIndex < 0) {
                dotIndex = this.fileNameSink.length();
            }
            try {
                this.partitionTimestamp = PartitionBy.getPartitionDirFormatMethod(this.partitionBy).parse(this.fileNameSink, 0, dotIndex, null);
            }
            catch (NumericException ex) {
                LOG.error().$("skipping column version purge VACUUM, invalid partition directory name [name=").$(this.fileNameSink).$(", path=").$(this.path2).I$();
                return;
            }
            long partitionNameTxn = -1L;
            if (dotIndex + 1 < this.fileNameSink.length()) {
                try {
                    partitionNameTxn = Numbers.parseLong(this.fileNameSink, dotIndex + 1, this.fileNameSink.length());
                }
                catch (NumericException ex) {
                    LOG.error().$("skipping column version purge VACUUM, invalid partition directory name [name=").$(this.fileNameSink).$(", path=").$(this.path2).I$();
                    return;
                }
            }
            if (partitionNameTxn != this.tableReader.getTxFile().getPartitionNameTxnByPartitionTimestamp(this.partitionTimestamp)) {
                return;
            }
            this.path2.concat(pUtf8NameZ);
            LOG.info().$("enumerating files at ").$(this.path2).$();
            this.ff.iterateDir(this.path2.$(), this.visitTableFiles);
        }
    }
}

