/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.PurgingOperator;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.LongList;
import io.questdb.std.str.Path;

public class DropIndexOperator
extends PurgingOperator {
    private static final Log LOG = LogFactory.getLog(DropIndexOperator.class);
    private final Path other;
    private final LongList rollbackColumnVersions = new LongList();

    public DropIndexOperator(CairoConfiguration configuration, MessageBus messageBus, TableWriter tableWriter, Path path, Path other, int rootLen) {
        super(LOG, configuration, messageBus, tableWriter, path, rootLen);
        this.other = other;
    }

    public void executeDropIndex(CharSequence columnName, int columnIndex) {
        int partitionBy = this.tableWriter.getPartitionBy();
        int partitionCount = this.tableWriter.getPartitionCount();
        try {
            this.updateColumnIndexes.clear();
            this.cleanupColumnVersions.clear();
            this.rollbackColumnVersions.clear();
            for (int pIndex = 0; pIndex < partitionCount; ++pIndex) {
                long pTimestamp = this.tableWriter.getPartitionTimestamp(pIndex);
                long pVersion = this.tableWriter.getPartitionNameTxn(pIndex);
                long columnVersion = this.tableWriter.getColumnNameTxn(pTimestamp, columnIndex);
                long columnTop = this.tableWriter.getColumnTop(pTimestamp, columnIndex, -1L);
                if (columnTop == -1L) continue;
                this.tableWriter.upsertColumnVersion(pTimestamp, columnIndex, columnTop);
                long columnDropIndexVersion = this.tableWriter.getColumnNameTxn(pTimestamp, columnIndex);
                DropIndexOperator.partitionDFile(this.path, this.rootLen, partitionBy, pTimestamp, pVersion, columnName, columnVersion);
                DropIndexOperator.partitionDFile(this.other, this.rootLen, partitionBy, pTimestamp, pVersion, columnName, columnDropIndexVersion);
                if (-1 == this.ff.hardLink(this.path, this.other)) {
                    throw CairoException.critical(this.ff.errno()).put("cannot hardLink [src=").put(this.path).put(", hardLink=").put(this.other).put(']');
                }
                this.updateColumnIndexes.add(columnIndex);
                this.cleanupColumnVersions.add(columnIndex, columnVersion, pTimestamp, pVersion);
                this.rollbackColumnVersions.add(columnIndex, columnDropIndexVersion, pTimestamp, pVersion);
            }
        }
        catch (Throwable th) {
            LOG.error().$("Could not DROP INDEX: ").$(th.getMessage()).$();
            this.updateColumnIndexes.clear();
            this.cleanupColumnVersions.clear();
            int limit = this.rollbackColumnVersions.size();
            if (limit / 4 < partitionCount) {
                for (int i = 0; i < limit; i += 4) {
                    long columnDropIndexVersion = this.rollbackColumnVersions.getQuick(i + 1);
                    long pTimestamp = this.rollbackColumnVersions.getQuick(i + 2);
                    long partitionNameTxn = this.rollbackColumnVersions.getQuick(i + 3);
                    DropIndexOperator.partitionDFile(this.other, this.rootLen, partitionBy, pTimestamp, partitionNameTxn, columnName, columnDropIndexVersion);
                    if (this.ff.remove(this.other)) continue;
                    LOG.info().$("Please remove this file \"").$(this.other).$('\"').I$();
                }
            }
            throw th;
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private static void partitionDFile(Path path, int rootLen, int partitionBy, long partitionTimestamp, long partitionNameTxn, CharSequence columnName, long columnNameTxn) {
        TableUtils.setPathForPartition(path, rootLen, partitionBy, partitionTimestamp, partitionNameTxn);
        TableUtils.dFile(path, columnName, columnNameTxn);
    }
}

