/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.CountLong256GroupByFunction;
import io.questdb.griffin.engine.functions.groupby.CountLongConstGroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.ObjList;

public class CountLong256GroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "count(H)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            Long256 val = arg.getLong256A(null);
            if (val.equals(Long256Impl.NULL_LONG256)) {
                throw SqlException.$(argPositions.getQuick(0), "NULL is not allowed");
            }
            return new CountLongConstGroupByFunction();
        }
        return new CountLong256GroupByFunction(arg);
    }
}

